/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.item;

import com.mrbysco.resourcepandas.entity.ResourcePandaEntity;
import com.mrbysco.resourcepandas.item.PandaDataComponents;
import com.mrbysco.resourcepandas.registry.PandaRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PandaSpawnEggItem
extends SpawnEggItem {
    public PandaSpawnEggItem(Item.Properties properties) {
        super(properties.spawnEgg(PandaRegistry.RESOURCE_PANDA.get()));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockentity;
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        ResourceLocation resourceType = (ResourceLocation)itemstack.get(PandaDataComponents.RESOURCE_TYPE);
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        if (blockstate.is(Blocks.SPAWNER) && (blockentity = level.getBlockEntity(blockpos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerblockentity = (SpawnerBlockEntity)blockentity;
            EntityType<ResourcePandaEntity> type = PandaRegistry.RESOURCE_PANDA.get();
            if (resourceType != null) {
                ResourcePandaEntity panda = (ResourcePandaEntity)type.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
                if (panda != null) {
                    this.initializePanda(panda, resourceType);
                } else {
                    spawnerblockentity.setEntityId(type, level.getRandom());
                }
            } else {
                spawnerblockentity.setEntityId(type, level.getRandom());
            }
            blockentity.setChanged();
            level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            itemstack.shrink(1);
            return InteractionResult.CONSUME;
        }
        BlockPos pos2 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType<ResourcePandaEntity> type = PandaRegistry.RESOURCE_PANDA.get();
        ResourcePandaEntity panda = (ResourcePandaEntity)type.spawn((ServerLevel)level, itemstack, (LivingEntity)context.getPlayer(), pos2, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(blockpos, pos2) && direction == Direction.UP);
        if (panda != null) {
            this.initializePanda(panda, resourceType);
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public void initializePanda(ResourcePandaEntity panda, @Nullable ResourceLocation resourceType) {
        if (resourceType != null) {
            panda.setResourceDataById(resourceType);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        ResourceLocation resourceType = (ResourceLocation)stack.get(PandaDataComponents.RESOURCE_TYPE);
        if (resourceType != null) {
            String resource = flag.hasShiftDown() ? resourceType.toString() : resourceType.getPath();
            consumer.accept((Component)Component.literal((String)"Resource: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)resource).withStyle(ChatFormatting.GOLD)));
        }
    }
}

