/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.resourcepandas.recipe.PandaRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PandaRecipe
implements Recipe<SingleRecipeInput> {
    protected final String name;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final String hexColor;
    protected final float alpha;
    protected final float chance;

    public PandaRecipe(String name, Ingredient ingredient, ItemStack stack, String hexColor, float alpha, float chance) {
        this.name = name;
        this.ingredient = ingredient;
        this.result = stack;
        this.hexColor = hexColor;
        this.alpha = alpha;
        this.chance = chance;
    }

    @NotNull
    public RecipeType<PandaRecipe> getType() {
        return (RecipeType)PandaRecipes.PANDA_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    @NotNull
    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public boolean matches(SingleRecipeInput inv, @NotNull Level level) {
        return this.ingredient.test(inv.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput inventory, @NotNull HolderLookup.Provider provider) {
        return this.getResult();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public String getHexColor() {
        return this.hexColor;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getChance() {
        return this.chance;
    }

    @NotNull
    public RecipeSerializer<PandaRecipe> getSerializer() {
        return PandaRecipes.PANDA_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<PandaRecipe> {
        public static final MapCodec<PandaRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(recipe -> recipe.name), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.STRING.optionalFieldOf("hexColor", (Object)"#ffffff").forGetter(recipe -> recipe.hexColor), (App)Codec.FLOAT.optionalFieldOf("alpha", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.alpha)), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)instance, PandaRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PandaRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<PandaRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, PandaRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static PandaRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            String hex = buffer.readUtf(Short.MAX_VALUE);
            float alpha = buffer.readFloat();
            float chance = buffer.readFloat();
            return new PandaRecipe(s, ingredient, itemstack, hex, alpha, chance);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, PandaRecipe recipe) {
            buffer.writeUtf(recipe.name);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeUtf(recipe.hexColor);
            buffer.writeFloat(recipe.alpha);
            buffer.writeFloat(recipe.chance);
        }
    }
}

