/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.util;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderHelper {
    public static final Vector3f TRANSLATION = new Vector3f();
    public static final Quaternionf ANGLE = new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI);

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.level() == null) {
            return;
        }
        int startX = x - 50;
        int startY = y - 50;
        int endX = x + 50;
        int endY = y + 50;
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.scale((float)scale, (float)scale);
        livingEntity.yBodyRot = (float)(-(yaw / 40.0)) * 20.0f + 180.0f;
        livingEntity.setYRot((float)(-(yaw / 40.0)) * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot() + 180.0f;
        livingEntity.yHeadRotO = livingEntity.getYRot() + 180.0f;
        livingEntity.setXRot((float)(-(pitch / 5.0)));
        poseStack.translate(0.0f, (float)livingEntity.getVehicleAttachmentPoint((Entity)livingEntity).y());
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)startX, (int)startY, (int)endX, (int)endY, (float)((float)scale), (Vector3f)TRANSLATION, (Quaternionf)ANGLE, (Quaternionf)null, (LivingEntity)livingEntity);
        poseStack.popMatrix();
    }
}

