/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.resourcepandas.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.resourcepandas.Reference;
import com.mrbysco.resourcepandas.recipe.PandaRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

public record ResourceData(ResourceLocation id, String name, String hexColor, float alpha, float chance) {
    public static final ResourceData MISSING = new ResourceData(Reference.modLoc("missing"), "Missing", "#ffd79a", 1.0f, 2.0f);
    public static final Codec<ResourceData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ResourceData::id), (App)Codec.STRING.fieldOf("name").forGetter(ResourceData::name), (App)Codec.STRING.fieldOf("hexColor").forGetter(ResourceData::hexColor), (App)Codec.FLOAT.fieldOf("alpha").forGetter(ResourceData::alpha), (App)Codec.FLOAT.fieldOf("chance").forGetter(ResourceData::chance)).apply((Applicative)inst, ResourceData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, spoilTimer -> spoilTimer.id, (StreamCodec)ByteBufCodecs.STRING_UTF8, spoilTimer -> spoilTimer.name, (StreamCodec)ByteBufCodecs.STRING_UTF8, spoilTimer -> spoilTimer.hexColor, (StreamCodec)ByteBufCodecs.FLOAT, spoilTimer -> Float.valueOf(spoilTimer.alpha), (StreamCodec)ByteBufCodecs.FLOAT, spoilTimer -> Float.valueOf(spoilTimer.chance), ResourceData::new);

    public static ResourceData fromRecipe(RecipeHolder<PandaRecipe> recipeHolder) {
        PandaRecipe recipe = (PandaRecipe)recipeHolder.value();
        return new ResourceData(recipeHolder.id().location(), recipe.getName(), recipe.getHexColor(), recipe.getAlpha(), recipe.getChance());
    }
}

