/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair;

import com.mojang.logging.LogUtils;
import net.biorfn.repair.chest.blocks.BlockRepairChest;
import net.biorfn.repair.chest.registers.RepairChestReg;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.curios.RepairNecklaceRenderer;
import net.biorfn.repair.curios.RepairTalismanRenderer;
import net.biorfn.repair.registers.RepairItems;
import net.biorfn.repair.registers.RepairItemsGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="repair_mod")
public class RepairMod {
    public static final String MODID = "repair_mod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean isCuriosLoaded = false;
    public static boolean isSophisticatedBackpacksLoaded = false;
    public static boolean isStorageDrawersLoaded = false;

    public RepairMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        if (ModList.get().isLoaded("curios")) {
            isCuriosLoaded = true;
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            isSophisticatedBackpacksLoaded = true;
        }
        if (ModList.get().isLoaded("storagedrawers")) {
            isStorageDrawersLoaded = true;
        }
        RepairItems.register(modEventBus);
        RepairChestReg.register(modEventBus);
        RepairItemsGroup.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(e -> {
            if (e.getTab() == RepairItemsGroup.REPAIR_CREATIVE_TAB.get()) {
                RepairChestReg.CHESTS_ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
            }
        });
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (Block block : ((BlockEntityType)RepairChestReg.CHEST_TILE_TYPE.get()).getValidBlocks()) {
            event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, be, side) -> {
                BlockRepairChest chest;
                Container container;
                if (block instanceof BlockRepairChest && (container = ChestBlock.getContainer((ChestBlock)(chest = (BlockRepairChest)block), (BlockState)state, (Level)level, (BlockPos)pos, (boolean)false)) != null) {
                    return new InvWrapper(container);
                }
                return null;
            }, new Block[]{block});
        }
    }

    @EventBusSubscriber(modid="repair_mod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (isCuriosLoaded) {
                CuriosRendererRegistry.register((Item)((Item)RepairItems.NECKLESS_OF_REPAIR.get()), RepairNecklaceRenderer::new);
                CuriosRendererRegistry.register((Item)((Item)RepairItems.TALISMAN_OF_REPAIR.get()), RepairTalismanRenderer::new);
            }
        }
    }
}

