/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.chest.blocks;

import net.biorfn.repair.chest.blocks.EnumRepairChest;
import net.biorfn.repair.chest.registers.RepairChestReg;
import net.biorfn.repair.chest.tileentities.TileEntityRepairChest;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.RepairManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockRepairChest
extends ChestBlock {
    private final EnumRepairChest chestType;

    public BlockRepairChest(EnumRepairChest chestType) {
        super(BlockBehaviour.Properties.of().strength(2.0f), () -> (BlockEntityType)RepairChestReg.CHEST_TILE_TYPE.get());
        this.chestType = chestType;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityRepairChest(this.chestType, pos, state);
    }

    public EnumRepairChest getChestType() {
        return this.chestType;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileEntityRepairChest) {
            TileEntityRepairChest repairChest = (TileEntityRepairChest)blockEntity;
            this.repairItems(repairChest);
        }
        level.scheduleTick(pos, (Block)this, this.getTickRate());
    }

    private void repairItems(TileEntityRepairChest repairChest) {
        for (int i = 0; i < repairChest.getContainerSize(); ++i) {
            ItemStack itemstack = repairChest.getItem(i);
            if (!RepairManager.canItemBeRepaired(itemstack)) continue;
            int repairAmount = this.getRepairAmount();
            itemstack.setDamageValue(itemstack.getDamageValue() - repairAmount);
            if (this.chestType == EnumRepairChest.NECKLESS_CHEST) continue;
            return;
        }
    }

    private int getTickRate() {
        return switch (this.chestType) {
            default -> throw new MatchException(null, null);
            case EnumRepairChest.TALISMAN_CHEST -> Config.repairTalismanTick;
            case EnumRepairChest.NECKLESS_CHEST -> Config.repairNecklaceTick;
            case EnumRepairChest.RING_CHEST -> Config.repairRingTick;
        };
    }

    private int getRepairAmount() {
        return switch (this.chestType) {
            default -> throw new MatchException(null, null);
            case EnumRepairChest.TALISMAN_CHEST -> Config.repairTalismanDurability;
            case EnumRepairChest.NECKLESS_CHEST -> Config.repairNecklaceDurability;
            case EnumRepairChest.RING_CHEST -> Config.repairRingDurability;
        };
    }
}

