/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.chest.client;

import java.util.Locale;
import net.biorfn.repair.chest.blocks.EnumRepairChest;
import net.biorfn.repair.chest.tileentities.TileEntityRepairChest;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityRepairChestRenderer
extends ChestRenderer<TileEntityRepairChest> {
    public static Material[] single = new Material[EnumRepairChest.VALUES.length];
    public static Material[] left = new Material[EnumRepairChest.VALUES.length];
    public static Material[] right = new Material[EnumRepairChest.VALUES.length];

    public TileEntityRepairChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(TileEntityRepairChest blockEntity, ChestType chestType) {
        return TileEntityRepairChestRenderer.getChestMaterial(blockEntity, chestType);
    }

    private static Material getChestMaterial(String path) {
        return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"repair_mod", (String)("entity/chest/" + path)));
    }

    private static Material getChestMaterial(TileEntityRepairChest tile, ChestType chestType) {
        return switch (chestType) {
            case ChestType.LEFT -> left[tile.getChestType().ordinal()];
            case ChestType.RIGHT -> right[tile.getChestType().ordinal()];
            default -> single[tile.getChestType().ordinal()];
        };
    }

    static {
        for (EnumRepairChest chestType : EnumRepairChest.VALUES) {
            TileEntityRepairChestRenderer.single[chestType.ordinal()] = TileEntityRepairChestRenderer.getChestMaterial(chestType.name().toLowerCase(Locale.ENGLISH));
            TileEntityRepairChestRenderer.left[chestType.ordinal()] = TileEntityRepairChestRenderer.getChestMaterial(chestType.name().toLowerCase(Locale.ENGLISH) + "_left");
            TileEntityRepairChestRenderer.right[chestType.ordinal()] = TileEntityRepairChestRenderer.getChestMaterial(chestType.name().toLowerCase(Locale.ENGLISH) + "_right");
        }
    }
}

