/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.chest.registers;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.biorfn.repair.chest.blocks.BlockRepairChest;
import net.biorfn.repair.chest.blocks.EnumRepairChest;
import net.biorfn.repair.chest.client.TEIRRRepairChest;
import net.biorfn.repair.chest.tileentities.TileEntityRepairChest;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RepairChestReg {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"repair_mod");
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"repair_mod");
    public static final DeferredRegister<Item> CHESTS_ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"repair_mod");
    public static DeferredHolder<Block, BlockRepairChest>[] chests = new DeferredHolder[EnumRepairChest.VALUES.length];
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityRepairChest>> CHEST_TILE_TYPE;

    public static void register(IEventBus modEventBus) {
        for (EnumRepairChest chestType : EnumRepairChest.VALUES) {
            DeferredHolder chestObject;
            String chestName = chestType.name().toLowerCase(Locale.ENGLISH);
            RepairChestReg.chests[chestType.ordinal()] = chestObject = BLOCKS.register(chestName, () -> new BlockRepairChest(chestType));
            CHESTS_ITEMS.register(chestName, () -> new BlockItem((Block)chestObject.get(), new Item.Properties()){

                public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                    super.initializeClient(consumer);
                    consumer.accept(new IClientItemExtensions(this){

                        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                            return TEIRRRepairChest.INSTANCE;
                        }
                    });
                }
            });
        }
        CHEST_TILE_TYPE = TILE_ENTITIES.register("chest_tile", () -> BlockEntityType.Builder.of(TileEntityRepairChest::new, (Block[])((Block[])Arrays.stream(chests).map(DeferredHolder::get).toArray(Block[]::new))).build(null));
        BLOCKS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CHESTS_ITEMS.register(modEventBus);
    }
}

