/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.datagen;

import net.biorfn.repair.chest.blocks.EnumRepairChest;
import net.biorfn.repair.registers.RepairItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class EnUsLangProvider
extends LanguageProvider {
    public EnUsLangProvider(PackOutput output, String locale) {
        super(output, "repair_mod", locale);
    }

    protected void addTranslations() {
        this.add((Item)RepairItems.RING_OF_REPAIR.get(), "Ring Of Repair");
        this.add((Item)RepairItems.TALISMAN_OF_REPAIR.get(), "Repair Talisman");
        this.add((Item)RepairItems.NECKLESS_OF_REPAIR.get(), "Necklace of Repair");
        this.add("creative_tab.repair_mod.repair_items", "Repair Items");
        this.addChest();
    }

    private void addChest() {
        for (EnumRepairChest chestType : EnumRepairChest.VALUES) {
            String key = "block.repair_mod." + chestType.name().toLowerCase();
            String value = this.formatChestName(chestType) + " of Repair Chest";
            this.add(key, value);
        }
    }

    private String formatChestName(EnumRepairChest chestType) {
        String name = chestType.name().toLowerCase().replace("_chest", " ");
        return this.capitalizeWords(name);
    }

    private String capitalizeWords(String input) {
        String[] words = input.split(" ");
        StringBuilder capitalized = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return capitalized.toString().trim();
    }
}

