/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.datagen;

import java.util.concurrent.CompletableFuture;
import net.biorfn.repair.chest.blocks.EnumRepairChest;
import net.biorfn.repair.chest.registers.RepairChestReg;
import net.biorfn.repair.registers.RepairItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class RepairRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public RepairRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RepairItems.RING_OF_REPAIR.get())).pattern("EDE").pattern("I I").pattern("GGG").define(Character.valueOf('E'), (ItemLike)Items.EMERALD).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.EMERALD), RepairRecipeProvider.has((ItemLike)Items.EMERALD)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.DIAMOND), RepairRecipeProvider.has((ItemLike)Items.DIAMOND)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.GOLD_INGOT), RepairRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), RepairRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RepairItems.TALISMAN_OF_REPAIR.get())).pattern("CSC").pattern("CPC").pattern("CIC").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('I'), (ItemLike)Items.IRON_BLOCK).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.COPPER_INGOT), RepairRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.STRING), RepairRecipeProvider.has((ItemLike)Items.STRING)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.PAPER), RepairRecipeProvider.has((ItemLike)Items.PAPER)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.IRON_BLOCK), RepairRecipeProvider.has((ItemLike)Items.IRON_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RepairItems.NECKLESS_OF_REPAIR.get())).pattern("LSL").pattern("LRL").pattern("NTN").define(Character.valueOf('L'), (ItemLike)Items.CHAIN).define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('S'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('T'), (ItemLike)RepairItems.TALISMAN_OF_REPAIR.get()).define(Character.valueOf('R'), (ItemLike)RepairItems.RING_OF_REPAIR.get()).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)((ItemLike)RepairItems.RING_OF_REPAIR.get())), RepairRecipeProvider.has((ItemLike)((ItemLike)RepairItems.RING_OF_REPAIR.get()))).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)((ItemLike)RepairItems.TALISMAN_OF_REPAIR.get())), RepairRecipeProvider.has((ItemLike)((ItemLike)RepairItems.TALISMAN_OF_REPAIR.get()))).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.NETHER_STAR), RepairRecipeProvider.has((ItemLike)Items.NETHER_STAR)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.NETHERITE_INGOT), RepairRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.CHAIN), RepairRecipeProvider.has((ItemLike)Items.CHAIN)).save(recipeOutput);
        for (EnumRepairChest chestType : EnumRepairChest.VALUES) {
            String name = chestType.name().toLowerCase();
            Item repairItem = this.getItem(chestType);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RepairChestReg.chests[chestType.ordinal()].get())).pattern("PPP").pattern("PIP").pattern("PPP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('I'), (ItemLike)repairItem).unlockedBy("has_planks", RepairRecipeProvider.has((TagKey)ItemTags.PLANKS)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)repairItem), RepairRecipeProvider.has((ItemLike)repairItem)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"repair_mod", (String)("repair_" + name)));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RepairChestReg.chests[chestType.ordinal()].get())).requires((ItemLike)repairItem).requires((ItemLike)Items.CHEST).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)repairItem), RepairRecipeProvider.has((ItemLike)repairItem)).unlockedBy(RepairRecipeProvider.getHasName((ItemLike)Items.CHEST), RepairRecipeProvider.has((ItemLike)Items.CHEST)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"repair_mod", (String)("repair_" + name + "_from_chest")));
        }
    }

    private Item getItem(EnumRepairChest chestType) {
        return switch (chestType) {
            case EnumRepairChest.RING_CHEST -> (Item)RepairItems.RING_OF_REPAIR.get();
            case EnumRepairChest.NECKLESS_CHEST -> (Item)RepairItems.NECKLESS_OF_REPAIR.get();
            default -> (Item)RepairItems.TALISMAN_OF_REPAIR.get();
        };
    }
}

