/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.items;

import net.biorfn.repair.RepairMod;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.RepairManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;

public class RepairRing
extends Item {
    public RepairRing() {
        super(new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isRepairRingInCurios = false;
        if (RepairMod.isCuriosLoaded) {
            isRepairRingInCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(curios -> {
                for (int i = 0; i < curios.getEquippedCurios().getSlots(); ++i) {
                    ItemStack curioItem = curios.getEquippedCurios().getStackInSlot(i);
                    if (!(curioItem.getItem() instanceof RepairRing)) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        if (!level.isClientSide) {
            boolean activeInInventory = RepairManager.inventoryTickable && player.getInventory().contains(stack);
            RepairManager.setRingActive((isRepairRingInCurios || activeInInventory) && !RepairManager.isNecklessActive);
        }
        if (RepairManager.inventoryTickable || isRepairRingInCurios) {
            RepairManager.repairItems(player, Config.repairRingTick, Config.repairRingDurability);
            if (RepairManager.repairNearbyChestInv) {
                RepairManager.repairItemsNearby(player, level, Config.repairRingTick, Config.repairRingDurability);
            }
        }
        if (isRepairRingInCurios || RepairManager.inventoryTickable && RepairMod.isCuriosLoaded) {
            RepairManager.repairCurios(player, Config.repairRingTick, Config.repairRingDurability);
        }
    }
}

