/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.biorfn.repair.config.Config;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ConfigCondition(String configKey, boolean expectedValue) implements ICondition
{
    public static final MapCodec<ConfigCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("config_key").forGetter(ConfigCondition::configKey), (App)Codec.BOOL.fieldOf("expected_value").forGetter(ConfigCondition::expectedValue)).apply((Applicative)instance, ConfigCondition::new));

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public boolean test(ICondition.IContext iContext) {
        return switch (this.configKey) {
            case "oldWay" -> {
                if (Config.oldWayValue == this.expectedValue) {
                    yield true;
                }
                yield false;
            }
            case "inventoryTickable" -> {
                if (Config.inventoryTickableValue == this.expectedValue) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

