/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="repair_mod")
public class ItemUsageTracker {
    private static final Map<String, Long> lastUsageTimeMap = new HashMap<String, Long>();
    private static final long USAGE_BUFFER_MS = 2000L;

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()), player.getInventory().selected);
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()), player.getInventory().selected);
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()), player.getInventory().selected);
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()), player.getInventory().selected);
    }

    private static void markAsUsed(UUID itemUUID, int slotId) {
        String key = ItemUsageTracker.generateKey(itemUUID, slotId);
        lastUsageTimeMap.put(key, System.currentTimeMillis());
    }

    public static boolean isItemBeingUsed(UUID itemUUID, int slotId) {
        String key = ItemUsageTracker.generateKey(itemUUID, slotId);
        Long lastUsageTime = lastUsageTimeMap.get(key);
        if (lastUsageTime != null) {
            if (System.currentTimeMillis() - lastUsageTime < 2000L) {
                return true;
            }
            lastUsageTimeMap.remove(key);
        }
        return false;
    }

    public static UUID getUUIDFromItem(ItemStack item) {
        return UUID.nameUUIDFromBytes(item.toString().getBytes());
    }

    private static String generateKey(UUID itemUUID, int slotId) {
        return itemUUID.toString() + ":" + slotId;
    }
}

