/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.biorfn.repair.RepairMod;
import net.biorfn.repair.chest.tileentities.TileEntityRepairChest;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.items.RepairRing;
import net.biorfn.repair.items.RepairTalisman;
import net.biorfn.repair.util.ItemUsageTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class RepairManager {
    public static final boolean inventoryTickable = Config.inventoryTickableValue;
    public static boolean repairNearbyChestInv = Config.nearbyChestRepairValue;
    public static double MAX_DISTANCE = Config.maxDistanceValue;
    public static boolean oldWay = Config.oldWayValue;
    public static boolean isRingActive = false;
    public static boolean isTalismanActive = false;
    public static boolean isNecklessActive = false;

    public static void setRingActive(boolean active) {
        isRingActive = active;
    }

    public static void setTalismanActive(boolean active) {
        isTalismanActive = active;
    }

    public static void setNecklessActive(boolean active) {
        isNecklessActive = active;
    }

    public static boolean areBothActive() {
        return isRingActive && isTalismanActive;
    }

    public static void repairItems(Player player, int tickCount, int durability) {
        block14: {
            block17: {
                block16: {
                    block15: {
                        if (player.tickCount % tickCount != 0) break block14;
                        if (!oldWay && !isNecklessActive) break block15;
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack item = player.getInventory().getItem(i);
                            UUID itemUUID = RepairManager.getUUIDFromItem(item);
                            if (RepairManager.canItemBeRepaired(item) && !RepairManager.isItemBeingUsed(itemUUID, i)) {
                                RepairManager.itemRepair(item, durability);
                                continue;
                            }
                            if (!RepairMod.isSophisticatedBackpacksLoaded) continue;
                            RepairManager.repairSophisticatedBackpack(player, tickCount, durability, item, false);
                        }
                        break block14;
                    }
                    if (!RepairManager.areBothActive()) break block16;
                    if (inventoryTickable) {
                        if (RepairManager.isRingInPlayerInventory(player) && !RepairManager.isTalismanInPlayerInventory(player)) {
                            RepairManager.setTalismanActive(false);
                        } else if (!RepairManager.isRingInPlayerInventory(player) && RepairManager.isTalismanInPlayerInventory(player)) {
                            RepairManager.setRingActive(false);
                        }
                    }
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        ItemStack item = player.getInventory().getItem(i);
                        UUID itemUUID = RepairManager.getUUIDFromItem(item);
                        if (RepairMod.isSophisticatedBackpacksLoaded) {
                            RepairManager.repairSophisticatedBackpack(player, tickCount, durability, item, false);
                        }
                        if (!RepairManager.canItemBeRepaired(item) || RepairManager.isItemBeingUsed(itemUUID, i)) continue;
                        RepairManager.itemRepair(item, durability);
                        for (int j = i + 1; j < player.getInventory().getContainerSize(); ++j) {
                            ItemStack nextItem = player.getInventory().getItem(j);
                            UUID nextUUID = RepairManager.getUUIDFromItem(nextItem);
                            if (RepairMod.isSophisticatedBackpacksLoaded) {
                                RepairManager.repairSophisticatedBackpack(player, tickCount, durability, nextItem, false);
                            }
                            if (!RepairManager.canItemBeRepaired(nextItem) || RepairManager.isItemBeingUsed(nextUUID, j)) continue;
                            RepairManager.itemRepair(nextItem, durability);
                            return;
                        }
                        return;
                    }
                    break block14;
                }
                if (!isRingActive || isTalismanActive) break block17;
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack item = player.getInventory().getItem(i);
                    UUID itemUUID = RepairManager.getUUIDFromItem(item);
                    if (RepairManager.canItemBeRepaired(item)) {
                        if (RepairManager.isItemBeingUsed(itemUUID, i)) continue;
                        RepairManager.itemRepair(item, durability);
                        return;
                    }
                    if (!RepairMod.isSophisticatedBackpacksLoaded) continue;
                    RepairManager.repairSophisticatedBackpack(player, tickCount, durability, item, false);
                }
                break block14;
            }
            if (!isTalismanActive || isRingActive) break block14;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack item = player.getInventory().getItem(i);
                UUID itemUUID = RepairManager.getUUIDFromItem(item);
                if (RepairManager.canItemBeRepaired(item)) {
                    if (RepairManager.isItemBeingUsed(itemUUID, i)) continue;
                    RepairManager.itemRepair(item, durability);
                    return;
                }
                if (!RepairMod.isSophisticatedBackpacksLoaded) continue;
                RepairManager.repairSophisticatedBackpack(player, tickCount, durability, item, false);
            }
        }
    }

    public static void repairCurios(Player player, int tickCount, int durability) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
            for (int i = 0; i < curiosInv.getEquippedCurios().getSlots(); ++i) {
                ItemStack slotStackPair = curiosInv.getEquippedCurios().getStackInSlot(i);
                if (slotStackPair.isDamaged()) {
                    RepairManager.itemRepair(slotStackPair, durability);
                    continue;
                }
                if (!RepairMod.isSophisticatedBackpacksLoaded) continue;
                RepairManager.repairSophisticatedBackpack(player, tickCount, durability, slotStackPair, true);
            }
        });
    }

    public static void repairSophisticatedBackpack(Player player, int tickCount, int durability, ItemStack stack, boolean isCurios) {
        IItemHandler selectedHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (selectedHandler == null) {
            return;
        }
        if (isCurios) {
            RepairManager.repairItemsInHandler(selectedHandler, tickCount, durability, player);
        }
        if (RepairManager.isSophisticatedSelected(player, stack)) {
            RepairManager.repairItemsInHandler(selectedHandler, tickCount, durability, player);
            return;
        }
        if (RepairManager.isSophisticatedEquipped(player, stack)) {
            RepairManager.repairItemsInHandler(selectedHandler, tickCount, durability, player);
        }
    }

    public static void repairItemsNearby(Player player, Level level, int tickCount, int durability) {
        BlockPos playerPos = player.blockPosition();
        int maxDistance = (int)MAX_DISTANCE;
        for (int x = -maxDistance; x <= maxDistance; ++x) {
            for (int y = -maxDistance; y <= maxDistance; ++y) {
                for (int z = -maxDistance; z <= maxDistance; ++z) {
                    ResourceLocation blockId;
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity(checkPos);
                    BlockState blockState = level.getBlockState(checkPos);
                    Block block = blockState.getBlock();
                    if (RepairMod.isStorageDrawersLoaded && (blockId = BuiltInRegistries.BLOCK.getKey((Object)block)) != null && blockId.toString().startsWith("storagedrawers") || blockEntity instanceof SmokerBlockEntity || blockEntity instanceof FurnaceBlockEntity || blockEntity instanceof BlastFurnaceBlockEntity || blockEntity instanceof TileEntityRepairChest) continue;
                    IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, checkPos, null);
                    if (itemHandler != null) {
                        RepairManager.repairItemsInHandler(itemHandler, tickCount, durability, player);
                    }
                    if (!(blockEntity instanceof EnderChestBlockEntity)) continue;
                    RepairManager.repairPlayerEnderChest(player, tickCount, durability);
                }
            }
        }
    }

    private static void repairItemsInHandler(IItemHandler itemHandler, int tickCount, int durability, Player player) {
        block14: {
            block17: {
                block16: {
                    block15: {
                        if (player.tickCount % tickCount != 0) break block14;
                        if (!oldWay && !isNecklessActive) break block15;
                        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                            ItemStack stack = itemHandler.getStackInSlot(slot);
                            if (!RepairManager.canItemBeRepaired(stack)) continue;
                            RepairManager.itemRepair(stack, durability);
                            ItemStack extracted = itemHandler.extractItem(slot, stack.getCount(), false);
                            itemHandler.insertItem(slot, extracted, false);
                        }
                        break block14;
                    }
                    if (RepairManager.isPlayerInventoryRepairing(player) || RepairManager.isCuriosRepairing(player)) {
                        return;
                    }
                    if (!RepairManager.areBothActive()) break block16;
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        ItemStack stack = itemHandler.getStackInSlot(slot);
                        if (!RepairManager.canItemBeRepaired(stack)) continue;
                        if (stack.getCount() > 1) {
                            RepairManager.splitExcessStack(itemHandler, slot, stack);
                        }
                        ItemStack recheckedStack = itemHandler.getStackInSlot(slot);
                        RepairManager.itemRepair(recheckedStack, durability);
                        if (recheckedStack.getCount() == 1) {
                            ItemStack extracted = itemHandler.extractItem(slot, recheckedStack.getCount(), false);
                            itemHandler.insertItem(slot, extracted, false);
                        }
                        for (int nextSlot = slot + 1; nextSlot < itemHandler.getSlots(); ++nextSlot) {
                            ItemStack nextStack = itemHandler.getStackInSlot(nextSlot);
                            if (!RepairManager.canItemBeRepaired(nextStack)) continue;
                            if (nextStack.getCount() > 1) {
                                RepairManager.splitExcessStack(itemHandler, nextSlot, nextStack);
                            }
                            ItemStack recheckedStack2 = itemHandler.getStackInSlot(nextSlot);
                            RepairManager.itemRepair(nextStack, durability);
                            if (recheckedStack2.getCount() == 1) {
                                ItemStack extracted = itemHandler.extractItem(nextSlot, recheckedStack2.getCount(), false);
                                itemHandler.insertItem(nextSlot, extracted, false);
                            }
                            return;
                        }
                        return;
                    }
                    break block14;
                }
                if (!isRingActive || isTalismanActive) break block17;
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack stack = itemHandler.getStackInSlot(slot);
                    if (!RepairManager.canItemBeRepaired(stack)) continue;
                    if (stack.getCount() > 1) {
                        RepairManager.splitExcessStack(itemHandler, slot, stack);
                    }
                    ItemStack recheckedStack = itemHandler.getStackInSlot(slot);
                    RepairManager.itemRepair(recheckedStack, durability);
                    if (recheckedStack.getCount() == 1) {
                        ItemStack extracted = itemHandler.extractItem(slot, recheckedStack.getCount(), false);
                        itemHandler.insertItem(slot, extracted, false);
                    }
                    return;
                }
                break block14;
            }
            if (!isTalismanActive || isRingActive) break block14;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!RepairManager.canItemBeRepaired(stack)) continue;
                if (stack.getCount() > 1) {
                    RepairManager.splitExcessStack(itemHandler, slot, stack);
                }
                ItemStack recheckedStack = itemHandler.getStackInSlot(slot);
                RepairManager.itemRepair(recheckedStack, durability);
                if (recheckedStack.getCount() == 1) {
                    ItemStack extracted = itemHandler.extractItem(slot, recheckedStack.getCount(), false);
                    itemHandler.insertItem(slot, extracted, false);
                }
                return;
            }
        }
    }

    private static void repairPlayerEnderChest(Player player, int tickCount, int durability) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        if (player.tickCount % tickCount != 0) break block6;
                        if (!oldWay && !isNecklessActive) break block7;
                        for (int i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
                            ItemStack item = player.getEnderChestInventory().getItem(i);
                            if (!RepairManager.canItemBeRepaired(item)) continue;
                            RepairManager.itemRepair(item, durability);
                        }
                        break block6;
                    }
                    if (RepairManager.isPlayerInventoryRepairing(player) || RepairManager.isCuriosRepairing(player)) {
                        return;
                    }
                    if (!RepairManager.areBothActive()) break block8;
                    for (int i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
                        ItemStack item = player.getEnderChestInventory().getItem(i);
                        if (!RepairManager.canItemBeRepaired(item)) continue;
                        RepairManager.itemRepair(item, durability);
                        for (int j = i + 1; j < player.getEnderChestInventory().getContainerSize(); ++j) {
                            ItemStack nextStack = player.getEnderChestInventory().getItem(j);
                            if (!RepairManager.canItemBeRepaired(nextStack)) continue;
                            RepairManager.itemRepair(nextStack, durability);
                            return;
                        }
                        return;
                    }
                    break block6;
                }
                if (!isRingActive || isTalismanActive) break block9;
                for (int i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
                    ItemStack item = player.getEnderChestInventory().getItem(i);
                    if (!RepairManager.canItemBeRepaired(item)) continue;
                    RepairManager.itemRepair(item, durability);
                    return;
                }
                break block6;
            }
            if (!isTalismanActive || isRingActive) break block6;
            for (int i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
                ItemStack item = player.getEnderChestInventory().getItem(i);
                if (RepairManager.canItemBeRepaired(item)) continue;
                RepairManager.itemRepair(item, durability);
                return;
            }
        }
    }

    private static boolean isSophisticatedSelected(Player player, ItemStack stack) {
        ItemStack stack1 = player.getInventory().getSelected();
        if (stack1.getItem().equals(stack.getItem())) {
            return "sophisticatedbackpacks:backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:copper_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:iron_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:gold_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:diamond_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:netherite_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
        }
        return false;
    }

    private static boolean isSophisticatedEquipped(Player player, ItemStack stack) {
        ItemStack stack1 = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack1.getItem().equals(stack.getItem())) {
            return "sophisticatedbackpacks:backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:copper_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:iron_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:gold_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:diamond_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString()) || "sophisticatedbackpacks:netherite_backpack".equals(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
        }
        return false;
    }

    private static void itemRepair(ItemStack item, int durability) {
        item.setDamageValue(item.getDamageValue() - durability);
    }

    public static boolean canItemBeRepaired(ItemStack item) {
        return !item.isEmpty() && item.getDamageValue() > 0;
    }

    private static int hasEmptySlot(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.getStackInSlot(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    private static UUID getUUIDFromItem(ItemStack item) {
        return ItemUsageTracker.getUUIDFromItem(item);
    }

    private static boolean isItemBeingUsed(UUID itemUUID, int slotId) {
        return ItemUsageTracker.isItemBeingUsed(itemUUID, slotId);
    }

    private static boolean isPlayerInventoryRepairing(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.isEmpty() || stack.getDamageValue() <= 0 || !RepairManager.canItemBeRepaired(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCuriosRepairing(Player player) {
        AtomicBoolean isRepairing = new AtomicBoolean(false);
        if (RepairMod.isCuriosLoaded) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
                for (int i = 0; i < curiosInv.getEquippedCurios().getSlots(); ++i) {
                    ItemStack slotStackPair = curiosInv.getEquippedCurios().getStackInSlot(i);
                    if (!slotStackPair.isDamaged()) continue;
                    isRepairing.set(true);
                    return;
                }
            });
        }
        return isRepairing.get();
    }

    private static boolean isRingInPlayerInventory(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof RepairRing)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTalismanInPlayerInventory(Player player) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.isEmpty() || !(stack.getItem() instanceof RepairTalisman)) continue;
            return true;
        }
        return false;
    }

    private static void splitExcessStack(IItemHandler itemHandler, int slot, ItemStack stack) {
        int excessCount = stack.getCount() - 1;
        int emptySlot = RepairManager.hasEmptySlot(itemHandler);
        if (emptySlot != -1) {
            ItemStack excessStack = stack.split(excessCount);
            itemHandler.insertItem(emptySlot, excessStack, false);
        }
    }
}

