/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.config;

import net.biorfn.repair.RepairMod;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="repair_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.BooleanValue inventoryTickable = RepairMod.isCuriosLoaded ? BUILDER.comment("Enables the inventory tickable feature for the repair items. [Default: true] if no curios.").define("Inventory Tickable", false) : BUILDER.comment("Enables the inventory tickable feature for the repair items. [Default: true] if no curios.").define("Inventory Tickable", true);
    public static ForgeConfigSpec.BooleanValue nearbyChestRepair = BUILDER.comment("Enables the repair feature for items in nearby chests. [Default: false]").push("Chest Repair").define("Nearby Chest Repair", false);
    public static final ForgeConfigSpec.DoubleValue maxDistance = BUILDER.comment("Maximum distance from player to chest to repair items in.").push("MaxDistance [Default: 5.0]").defineInRange("MaxDistance", 5.0, 0.0, 20.0);
    public static final ForgeConfigSpec.IntValue talismanRepairInterval = BUILDER.pop(3).comment("Delay between Talisman of repair trying to repair player items while in a player's inventory [Default: 30]").push("Talisman").defineInRange("Repair", 30, -1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.IntValue talismanRepairDurabilityCount = BUILDER.comment("How much the items repair").push("Repair lvl [Default: 1]").defineInRange("Repair lvl", 1, 1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.IntValue necklaceRepairInterval = BUILDER.pop(2).comment("Delay between Necklace of repair trying to repair player items while in a player's inventory [Default: 15]").push("Necklace").defineInRange("Repair", 15, -1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.IntValue necklaceRepairDurabilityCount = BUILDER.comment("How much the items repair").push("Repair lvl [Default: 1]").defineInRange("Repair lvl", 1, 1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.IntValue ringRepairInterval = BUILDER.pop(2).comment("Delay between Ring of repair trying to repair player items while in a player's inventory [Default: 30]").push("Ring").defineInRange("Repair", 30, -1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec.IntValue ringRepairDurabilityCount = BUILDER.comment("How much the items repair").push("Repair lvl [Default: 1]").defineInRange("Repair lvl", 1, 1, Integer.MAX_VALUE);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean inventoryTickableValue;
    public static boolean nearbyChestRepairValue;
    public static double maxDistanceValue;
    public static int repairTalismanTick;
    public static int repairNecklaceTick;
    public static int repairRingTick;
    public static int repairRingDurability;
    public static int repairTalismanDurability;
    public static int repairNecklaceDurability;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.loadConfig();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading event) {
        Config.loadConfig();
        RepairMod.LOGGER.debug("OnFileChange: Config: Reloading config file {}", (Object)"repair_mod");
    }

    private static void loadConfig() {
        RepairMod.LOGGER.debug("Config:Loading config file {}", (Object)"repair_mod");
        inventoryTickableValue = (Boolean)inventoryTickable.get();
        nearbyChestRepairValue = (Boolean)nearbyChestRepair.get();
        maxDistanceValue = (Double)maxDistance.get();
        repairTalismanTick = (Integer)talismanRepairInterval.get();
        repairTalismanDurability = (Integer)talismanRepairDurabilityCount.get();
        repairRingTick = (Integer)ringRepairInterval.get();
        repairRingDurability = (Integer)ringRepairDurabilityCount.get();
        repairNecklaceTick = (Integer)necklaceRepairInterval.get();
        repairNecklaceDurability = (Integer)necklaceRepairDurabilityCount.get();
        RepairMod.LOGGER.debug("Config:Loaded config file invTick: {} and nearChest: {}", (Object)inventoryTickableValue, (Object)nearbyChestRepairValue);
    }
}

