/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.UUID;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.ItemUsageTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class RepairManager {
    public static final boolean inventoryTickable = Config.inventoryTickableValue;
    public static boolean repairNearbyChestInv = Config.nearbyChestRepairValue;
    public static double MAX_DISTANCE = Config.maxDistanceValue;

    public static void repairItems(Player player, int tickCount, int durability) {
        if (player.f_19797_ % tickCount == 0) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack item = player.m_150109_().m_8020_(i);
                UUID itemUUID = ItemUsageTracker.getUUIDFromItem(item);
                if (item.m_41619_() || item.m_41773_() <= 0 || ItemUsageTracker.isItemBeingUsed(itemUUID)) continue;
                item.m_41721_(item.m_41773_() - durability);
            }
        }
    }

    public static void repairCurios(Player player, int durability) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
            for (int i = 0; i < curiosInv.getEquippedCurios().getSlots(); ++i) {
                ItemStack slotStackPair = curiosInv.getEquippedCurios().getStackInSlot(i);
                if (!slotStackPair.m_41768_()) continue;
                slotStackPair.m_41721_(slotStackPair.m_41773_() - durability);
            }
        });
    }

    public static void repairItemsNearby(Player player, Level level, int tickCount, int durability) {
        BlockPos playerPos = player.m_20183_();
        int maxDistance = (int)MAX_DISTANCE;
        for (int x = -maxDistance; x <= maxDistance; ++x) {
            for (int y = -maxDistance; y <= maxDistance; ++y) {
                for (int z = -maxDistance; z <= maxDistance; ++z) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = level.m_7702_(checkPos);
                    if (blockEntity == null || blockEntity instanceof SmokerBlockEntity || blockEntity instanceof FurnaceBlockEntity || blockEntity instanceof BlastFurnaceBlockEntity) continue;
                    blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(itemHandler -> RepairManager.repairItemsInHandler(itemHandler, tickCount, durability, player));
                    if (!(blockEntity instanceof EnderChestBlockEntity)) continue;
                    RepairManager.repairPlayerEnderChest(player, tickCount, durability);
                }
            }
        }
    }

    private static void repairItemsInHandler(IItemHandler itemHandler, int tickCount, int durability, Player player) {
        if (player.f_19797_ % tickCount == 0) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.m_41619_() || stack.m_41773_() <= 0) continue;
                stack.m_41721_(stack.m_41773_() - durability);
            }
        }
    }

    private static void repairPlayerEnderChest(Player player, int tickCount, int durability) {
        if (player.f_19797_ % tickCount == 0) {
            for (int i = 0; i < player.m_36327_().m_6643_(); ++i) {
                ItemStack item = player.m_36327_().m_8020_(i);
                if (item.m_41619_() || item.m_41773_() <= 0) continue;
                item.m_41721_(item.m_41773_() - durability);
            }
        }
    }
}

