/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.config;

import net.biorfn.repair.RepairMod;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="repair_mod", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec.BooleanValue inventoryTickable = RepairMod.isCuriosLoaded ? BUILDER.comment("Enables the inventory tickable feature for the repair items. [Default: true] if no curios.").define("Inventory Tickable", false) : BUILDER.comment("Enables the inventory tickable feature for the repair items. [Default: true] if no curios.").define("Inventory Tickable", true);
    public static ModConfigSpec.BooleanValue nearbyChestRepair = BUILDER.comment("Enables the repair feature for items in nearby chests. [Default: false]").push("Chest Repair").define("Nearby Chest Repair", false);
    public static final ModConfigSpec.DoubleValue maxDistance = BUILDER.comment("Maximum distance from player to chest to repair items in.").push("MaxDistance [Default: 5.0]").defineInRange("MaxDistance", 5.0, 0.0, 20.0);
    public static final ModConfigSpec.IntValue talismanRepairInterval = BUILDER.pop(3).comment("Delay between Talisman of repair trying to repair player items while in a player's inventory [Default: 30]").push("Talisman").defineInRange("RepairTick", 30, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue talismanRepairDurabilityCount = BUILDER.comment("How much durability the items repair at a time").push("RepairDurability [Default: 1]").defineInRange("RepairDurability", 1, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue necklaceRepairInterval = BUILDER.pop(2).comment("Delay between Necklace of repair trying to repair player items while in a player's inventory [Default: 15]").push("Necklace").defineInRange("RepairTick", 15, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue necklaceRepairDurabilityCount = BUILDER.comment("How much durability the items repair at a time").push("RepairDurability [Default: 1]").defineInRange("RepairDurability", 1, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue ringRepairInterval = BUILDER.pop(2).comment("Delay between Ring of repair trying to repair player items while in a player's inventory [Default: 30]").push("Ring").defineInRange("RepairTick", 30, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec.IntValue ringRepairDurabilityCount = BUILDER.comment("How much durability the items repair at a time").push("RepairDurability [Default: 1]").defineInRange("RepairDurability", 1, 1, Integer.MAX_VALUE);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean inventoryTickableValue;
    public static boolean nearbyChestRepairValue;
    public static double maxDistanceValue;
    public static int repairTalismanTick;
    public static int repairNecklaceTick;
    public static int repairRingTick;
    public static int repairRingDurability;
    public static int repairNecklaceDurability;
    public static int repairTalismanDurability;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.loadConfig();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading event) {
        Config.loadConfig();
        RepairMod.LOGGER.debug("OnFileChange: Config: Reloading config file {}", (Object)"repair_mod");
    }

    public static void reloadConfig() {
        Config.loadConfig();
        RepairMod.LOGGER.debug("ReloadCalled: Config: Reloading config file {}", (Object)"repair_mod");
    }

    private static void loadConfig() {
        RepairMod.LOGGER.debug("Config:Loading config file {}", (Object)"repair_mod");
        inventoryTickableValue = (Boolean)inventoryTickable.get();
        nearbyChestRepairValue = (Boolean)nearbyChestRepair.get();
        maxDistanceValue = (Double)maxDistance.get();
        repairTalismanTick = (Integer)talismanRepairInterval.get();
        repairTalismanDurability = (Integer)talismanRepairDurabilityCount.get();
        repairRingTick = (Integer)ringRepairInterval.get();
        repairRingDurability = (Integer)ringRepairDurabilityCount.get();
        repairNecklaceTick = (Integer)necklaceRepairInterval.get();
        repairNecklaceDurability = (Integer)necklaceRepairDurabilityCount.get();
        RepairMod.LOGGER.debug("Config:Loaded config file invTick: {} and nearChest: {}", (Object)inventoryTickableValue, (Object)nearbyChestRepairValue);
    }
}

