/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.biorfn.repair.RepairMod;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static Config INSTANCE;
    public static final File CONFIG_FILE;
    private static final Gson GSON;
    public int ringRepairInterval = 30;
    public int ringRepairDurabilityCount = 1;
    public int talismanRepairInterval = 30;
    public int talismanRepairDurabilityCount = 1;
    public int necklaceRepairInterval = 15;
    public int necklaceRepairDurabilityCount = 1;
    public boolean inventoryTickableRepair;
    public boolean nearbyChestRepairValue;
    public double maxDistanceValue = 5.0;
    private static final double MIN_MAX_DISTANCE = 0.0;
    private static final double MAX_MAX_DISTANCE = 20.0;
    private static final int MIN_REPAIR_INTERVAL = 1;
    private static final int MAX_REPAIR_INTERVAL = 60;
    private static final int MIN_REPAIR_COUNT = 1;
    private static final int MAX_REPAIR_COUNT = 5;

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Config();
        }
        return INSTANCE;
    }

    public void loadConfig() {
        block8: {
            try {
                if (!CONFIG_FILE.exists()) {
                    this.inventoryTickableRepair = !FabricLoader.getInstance().isModLoaded("trinkets");
                    this.nearbyChestRepairValue = false;
                    this.saveConfig();
                    break block8;
                }
                try (JsonReader reader = new JsonReader((Reader)new FileReader(CONFIG_FILE));){
                    Map jsonMap = (Map)GSON.fromJson(reader, Map.class);
                    this.inventoryTickableRepair = (Boolean)jsonMap.get("inventoryTickableRepair");
                    this.nearbyChestRepairValue = jsonMap.get("nearbyChestRepairValue") == null ? false : (Boolean)jsonMap.get("nearbyChestRepairValue");
                    this.maxDistanceValue = jsonMap.get("maxDistanceValue") == null ? 5.0 : (Double)jsonMap.get("maxDistanceValue");
                    this.ringRepairInterval = ((Number)jsonMap.get("ringRepairInterval")).intValue();
                    this.ringRepairDurabilityCount = ((Number)jsonMap.get("ringRepairDurabilityCount")).intValue();
                    this.talismanRepairInterval = ((Number)jsonMap.get("talismanRepairInterval")).intValue();
                    this.talismanRepairDurabilityCount = ((Number)jsonMap.get("talismanRepairDurabilityCount")).intValue();
                    this.necklaceRepairInterval = ((Number)jsonMap.get("necklaceRepairInterval")).intValue();
                    this.necklaceRepairDurabilityCount = ((Number)jsonMap.get("necklaceRepairDurabilityCount")).intValue();
                }
                this.validateConfig();
            }
            catch (IOException e) {
                RepairMod.LOGGER.error("loadConfig: error: {}", (Object)e.getMessage());
            }
        }
    }

    public void reloadConfig() {
        try {
            RepairMod.LOGGER.info("Reloading configuration...");
            this.loadConfig();
            RepairMod.LOGGER.info("Configuration reloaded successfully.");
        }
        catch (Exception e) {
            RepairMod.LOGGER.error("Failed to reload configuration: {}", (Object)e.getMessage());
        }
    }

    private void validateConfig() {
        if (this.ringRepairInterval < 1 || this.ringRepairInterval > 60) {
            RepairMod.LOGGER.info("Ring repair interval out of range. Resetting to nearest valid value.");
            this.ringRepairInterval = Math.max(1, Math.min(this.ringRepairInterval, 60));
        }
        if (this.ringRepairDurabilityCount < 1 || this.ringRepairDurabilityCount > 5) {
            RepairMod.LOGGER.info("Ring repair count out of range. Resetting to nearest valid value.");
            this.ringRepairDurabilityCount = Math.max(1, Math.min(this.ringRepairDurabilityCount, 5));
        }
        if (this.talismanRepairInterval < 1 || this.talismanRepairInterval > 60) {
            RepairMod.LOGGER.info("Talisman repair interval out of range. Resetting to nearest valid value.");
            this.talismanRepairInterval = Math.max(1, Math.min(this.talismanRepairInterval, 60));
        }
        if (this.talismanRepairDurabilityCount < 1 || this.talismanRepairDurabilityCount > 5) {
            RepairMod.LOGGER.info("Talisman repair count out of range. Resetting to nearest valid value.");
            this.talismanRepairDurabilityCount = Math.max(1, Math.min(this.talismanRepairDurabilityCount, 5));
        }
        if (this.necklaceRepairInterval < 1 || this.necklaceRepairInterval > 60) {
            RepairMod.LOGGER.info("Necklace repair interval out of range. Resetting to nearest valid value.");
            this.necklaceRepairInterval = Math.max(1, Math.min(this.necklaceRepairInterval, 60));
        }
        if (this.necklaceRepairDurabilityCount < 1 || this.necklaceRepairDurabilityCount > 5) {
            RepairMod.LOGGER.info("Necklace repair count out of range. Resetting to nearest valid value.");
            this.necklaceRepairDurabilityCount = Math.max(1, Math.min(this.necklaceRepairDurabilityCount, 5));
        }
        if (this.maxDistanceValue < 0.0 || this.maxDistanceValue > 20.0) {
            RepairMod.LOGGER.info("Max distance value out of range. Resetting to nearest valid value.");
            this.maxDistanceValue = Math.max(0.0, Math.min(this.maxDistanceValue, 20.0));
        }
        this.saveConfig();
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            String jsonContent = "{\n  \"info_inventoryTickableRepair\": \"Controls whether the inventory is ticked with repair when not in a trinkets slot. Range: true/false.\",\n  \"info_inventoryTickableRepair_Default\": \"The inventory ticked repair is Defaulted to true if trinkets is not in the pack.\",\n  \"inventoryTickableRepair\": " + this.inventoryTickableRepair + ",\n  \"info_nearbyChestRepairValue\": \"Controls whether the repair feature for items in nearby chests. Range: true/false.\",\n  \"nearbyChestRepairValue\": " + this.nearbyChestRepairValue + ",\n  \"info_maxDistanceValue\": \"Controls how far away items can be to be repaired. Range: 0.0-20.0.\",\n  \"maxDistanceValue\": " + this.maxDistanceValue + ",\n  \"info_ringRepairInterval\": \"Controls how often the ring repairs an item. Range: 1-60 seconds.\",\n  \"ringRepairInterval\": " + this.ringRepairInterval + ",\n  \"info_ringRepairDurabilityCount\": \"Controls how much durability the ring repairs on item at once. Range: 1-5.\",\n  \"ringRepairDurabilityCount\": " + this.ringRepairDurabilityCount + ",\n  \"info_talismanRepairInterval\": \"Controls how often the talisman repairs an item. Range: 1-60 seconds.\",\n  \"talismanRepairInterval\": " + this.talismanRepairInterval + ",\n  \"info_talismanRepairDurabilityCount\": \"Controls how much durability the talisman repairs on item at once. Range: 1-5.\",\n  \"talismanRepairDurabilityCount\": " + this.talismanRepairDurabilityCount + ",\n  \"info_necklaceRepairInterval\": \"Controls how often the necklace repairs an item. Range: 1-60 seconds.\",\n  \"necklaceRepairInterval\": " + this.necklaceRepairInterval + ",\n  \"info_necklaceRepairDurabilityCount\": \"Controls how much durability the necklace repairs on item at once. Range: 1-5.\",\n  \"necklaceRepairDurabilityCount\": " + this.necklaceRepairDurabilityCount + "\n}";
            writer.write(jsonContent);
        }
        catch (IOException e) {
            RepairMod.LOGGER.error("saveConfig: error: {}", (Object)e.getMessage());
        }
    }

    static {
        CONFIG_FILE = new File("config/itemRepairConfig.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

