/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1799;

public class ItemUsageTracker {
    private static final Map<UUID, Long> lastUsageTimeMap = new HashMap<UUID, Long>();
    private static final long USAGE_BUFFER_MS = 2000L;

    public static void registerEvents() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (!world.field_9236) {
                ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.method_5998(hand)));
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (!world.field_9236) {
                ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.method_6047()));
            }
            return true;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!world.field_9236) {
                ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.method_6047()));
            }
            return class_1269.field_5811;
        });
    }

    private static void markAsUsed(UUID itemUUID) {
        lastUsageTimeMap.put(itemUUID, System.currentTimeMillis());
    }

    public static boolean isItemBeingUsed(UUID itemUUID) {
        Long lastUsageTime = lastUsageTimeMap.get(itemUUID);
        if (lastUsageTime != null) {
            return System.currentTimeMillis() - lastUsageTime < 2000L;
        }
        return false;
    }

    public static UUID getUUIDFromItem(class_1799 item) {
        return UUID.nameUUIDFromBytes(item.toString().getBytes());
    }
}

