/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.items;

import com.swacky.ohmega.api.AccessoryType;
import com.swacky.ohmega.api.IAccessory;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.RepairManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RepairRingOhmega
extends Item
implements IAccessory {
    boolean equippedItem = false;

    public RepairRingOhmega() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public AccessoryType getType() {
        return AccessoryType.UTILITY;
    }

    public void tick(Player player, ItemStack stack) {
        if (this.equippedItem) {
            RepairManager.repairItems(player, Config.repairRingTick, Config.repairRingDurability);
            if (RepairManager.repairNearbyChestInv) {
                RepairManager.repairItemsNearby(player, player.level(), Config.repairRingTick, Config.repairRingDurability);
            }
        }
    }

    public void onEquip(Player player, ItemStack stack) {
        this.equippedItem = true;
    }

    public void onUnequip(Player player, ItemStack stack) {
        this.equippedItem = false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (RepairManager.inventoryTickable && !this.equippedItem) {
            RepairManager.repairItems(player, Config.repairRingTick, Config.repairRingDurability);
            if (RepairManager.repairNearbyChestInv) {
                RepairManager.repairItemsNearby(player, level, Config.repairRingTick, Config.repairRingDurability);
            }
        }
    }
}

