/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="repair_mod")
public class ItemUsageTracker {
    private static final Map<UUID, Long> lastUsageTimeMap = new HashMap<UUID, Long>();
    private static final long USAGE_BUFFER_MS = 2000L;

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()));
    }

    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()));
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()));
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemUsageTracker.markAsUsed(ItemUsageTracker.getUUIDFromItem(player.getMainHandItem()));
    }

    private static void markAsUsed(UUID itemUUID) {
        lastUsageTimeMap.put(itemUUID, System.currentTimeMillis());
    }

    public static boolean isItemBeingUsed(UUID itemUUID) {
        Long lastUsageTime = lastUsageTimeMap.get(itemUUID);
        if (lastUsageTime != null) {
            return System.currentTimeMillis() - lastUsageTime < 2000L;
        }
        return false;
    }

    public static UUID getUUIDFromItem(ItemStack item) {
        return UUID.nameUUIDFromBytes(item.toString().getBytes());
    }
}

