/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.datagen;

import java.util.concurrent.CompletableFuture;
import net.biorfn.repair.datagen.EnUsLangProvider;
import net.biorfn.repair.datagen.RepairCuriosProvider;
import net.biorfn.repair.datagen.RepairItemsModelProvider;
import net.biorfn.repair.datagen.RepairRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="repair_mod", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RepairRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RepairCuriosProvider(packOutput, existingFileHelper, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new RepairItemsModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EnUsLangProvider(packOutput, "en_us"));
    }
}

