/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.items;

import net.biorfn.repair.RepairMod;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.RepairManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;

public class RepairNeckless
extends Item {
    public RepairNeckless() {
        super(new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isRepairNecklaceInCurios = false;
        if (RepairMod.isCuriosLoaded) {
            isRepairNecklaceInCurios = CuriosApi.getCuriosInventory((LivingEntity)player).map(curios -> {
                for (int i = 0; i < curios.getEquippedCurios().getSlots(); ++i) {
                    ItemStack curioItem = curios.getEquippedCurios().getStackInSlot(i);
                    if (!(curioItem.getItem() instanceof RepairNeckless)) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        if (RepairManager.inventoryTickable || isRepairNecklaceInCurios) {
            RepairManager.repairItems(player, Config.repairNecklaceTick, Config.repairNecklaceDurability);
            if (RepairManager.repairNearbyChestInv) {
                RepairManager.repairItemsNearby(player, level, Config.repairNecklaceTick, Config.repairNecklaceDurability);
            }
        }
        if (isRepairNecklaceInCurios || RepairManager.inventoryTickable && RepairMod.isCuriosLoaded) {
            RepairManager.repairCurios(player, Config.repairNecklaceDurability);
        }
    }
}

