/*
 * Decompiled with CFR 0.152.
 */
package net.biorfn.repair.util;

import java.util.UUID;
import net.biorfn.repair.config.Config;
import net.biorfn.repair.util.ItemUsageTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class RepairManager {
    public static final boolean inventoryTickable = Config.inventoryTickableValue;
    public static boolean repairNearbyChestInv = Config.nearbyChestRepairValue;
    public static double MAX_DISTANCE = Config.maxDistanceValue;

    public static void repairItems(Player player, int tickCount, int durability) {
        if (player.tickCount % tickCount == 0) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack item = player.getInventory().getItem(i);
                UUID itemUUID = ItemUsageTracker.getUUIDFromItem(item);
                if (item.isEmpty() || item.getDamageValue() <= 0 || ItemUsageTracker.isItemBeingUsed(itemUUID)) continue;
                item.setDamageValue(item.getDamageValue() - durability);
            }
        }
    }

    public static void repairCurios(Player player, int durability) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
            for (int i = 0; i < curiosInv.getEquippedCurios().getSlots(); ++i) {
                ItemStack slotStackPair = curiosInv.getEquippedCurios().getStackInSlot(i);
                if (!slotStackPair.isDamaged()) continue;
                slotStackPair.setDamageValue(slotStackPair.getDamageValue() - durability);
            }
        });
    }

    public static void repairItemsNearby(Player player, Level level, int tickCount, int durability) {
        BlockPos playerPos = player.blockPosition();
        int maxDistance = (int)MAX_DISTANCE;
        for (int x = -maxDistance; x <= maxDistance; ++x) {
            for (int y = -maxDistance; y <= maxDistance; ++y) {
                for (int z = -maxDistance; z <= maxDistance; ++z) {
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity(checkPos);
                    if (blockEntity instanceof SmokerBlockEntity || blockEntity instanceof FurnaceBlockEntity || blockEntity instanceof BlastFurnaceBlockEntity) continue;
                    IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, checkPos, null);
                    if (itemHandler != null) {
                        RepairManager.repairItemsInHandler(itemHandler, tickCount, durability, player);
                    }
                    if (!(blockEntity instanceof EnderChestBlockEntity)) continue;
                    RepairManager.repairPlayerEnderChest(player, tickCount, durability);
                }
            }
        }
    }

    private static void repairItemsInHandler(IItemHandler itemHandler, int tickCount, int durability, Player player) {
        if (player.tickCount % tickCount == 0) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.isEmpty() || stack.getDamageValue() <= 0) continue;
                stack.setDamageValue(stack.getDamageValue() - durability);
            }
        }
    }

    private static void repairPlayerEnderChest(Player player, int tickCount, int durability) {
        if (player.tickCount % tickCount == 0) {
            for (int i = 0; i < player.getEnderChestInventory().getContainerSize(); ++i) {
                ItemStack item = player.getEnderChestInventory().getItem(i);
                if (item.isEmpty() || item.getDamageValue() <= 0) continue;
                item.setDamageValue(item.getDamageValue() - durability);
            }
        }
    }
}

