/*
 * Decompiled with CFR 0.152.
 */
package blazingtwist.antitoolbreak;

import blazingtwist.antitoolbreak.ATB_ToolMaterial;
import blazingtwist.antitoolbreak.config.AntiToolBreakConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class AntiToolBreak
implements ModInitializer {
    private static final class_1792[] woodenItems = new class_1792[]{class_1802.field_8406, class_1802.field_8167, class_1802.field_8647, class_1802.field_8876, class_1802.field_8091};
    private static final class_1792[] stoneItems = new class_1792[]{class_1802.field_8062, class_1802.field_8431, class_1802.field_8387, class_1802.field_8776, class_1802.field_8528};
    private static final class_1792[] copperItems = new class_1792[]{class_1802.field_61341, class_1802.field_61342, class_1802.field_61340, class_1802.field_61339, class_1802.field_61338};
    private static final class_1792[] ironItems = new class_1792[]{class_1802.field_8475, class_1802.field_8609, class_1802.field_8403, class_1802.field_8699, class_1802.field_8371};
    private static final class_1792[] goldItems = new class_1792[]{class_1802.field_8825, class_1802.field_8303, class_1802.field_8335, class_1802.field_8322, class_1802.field_8845};
    private static final class_1792[] diamondItems = new class_1792[]{class_1802.field_8556, class_1802.field_8527, class_1802.field_8377, class_1802.field_8250, class_1802.field_8802};
    private static final class_1792[] netheriteItems = new class_1792[]{class_1802.field_22025, class_1802.field_22026, class_1802.field_22024, class_1802.field_22023, class_1802.field_22022};
    private static ConfigHolder<AntiToolBreakConfig> configHolder;
    private static HashMap<ATB_ToolMaterial, List<Integer>> materialRawIDs;
    private static int lastCheckedID;
    private static boolean lastCheckedStatus;

    public static AntiToolBreakConfig getConfig() {
        return (AntiToolBreakConfig)configHolder.getConfig();
    }

    public static boolean isItemMaterialProtected(AntiToolBreakConfig config, class_1792 item) {
        int rawId = class_1792.method_7880((class_1792)item);
        if (!AntiToolBreak.isLastCheckedID(rawId)) {
            ATB_ToolMaterial itemMaterial = AntiToolBreak.findItemMaterial(rawId);
            boolean materialProtected = config.isMaterialProtected(itemMaterial);
            AntiToolBreak.setLastCheckedID(rawId, materialProtected);
        }
        return AntiToolBreak.getLastCheckedStatus();
    }

    private static HashMap<ATB_ToolMaterial, List<Integer>> getMaterialRawIDs() {
        if (materialRawIDs == null) {
            materialRawIDs = new HashMap();
            materialRawIDs.put(ATB_ToolMaterial.Wood, Arrays.stream(woodenItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Stone, Arrays.stream(stoneItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Copper, Arrays.stream(copperItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Iron, Arrays.stream(ironItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Gold, Arrays.stream(goldItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Diamond, Arrays.stream(diamondItems).map(class_1792::method_7880).collect(Collectors.toList()));
            materialRawIDs.put(ATB_ToolMaterial.Netherite, Arrays.stream(netheriteItems).map(class_1792::method_7880).collect(Collectors.toList()));
        }
        return materialRawIDs;
    }

    private static ATB_ToolMaterial findItemMaterial(int rawID) {
        return AntiToolBreak.getMaterialRawIDs().entrySet().stream().filter(materialEntry -> ((List)materialEntry.getValue()).contains(rawID)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    private static void setLastCheckedID(int rawID, boolean status) {
        lastCheckedID = rawID;
        lastCheckedStatus = status;
    }

    private static boolean isLastCheckedID(int rawID) {
        return lastCheckedID >= 0 && lastCheckedID == rawID;
    }

    private static boolean getLastCheckedStatus() {
        return lastCheckedStatus;
    }

    private static class_1269 resetMaterialCache(ConfigHolder<AntiToolBreakConfig> holder, AntiToolBreakConfig configInstance) {
        AntiToolBreak.setLastCheckedID(0, false);
        return class_1269.field_5811;
    }

    public void onInitialize() {
        AutoConfig.register(AntiToolBreakConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(AntiToolBreakConfig.class);
        configHolder.registerSaveListener(AntiToolBreak::resetMaterialCache);
        configHolder.registerLoadListener(AntiToolBreak::resetMaterialCache);
    }

    static {
        materialRawIDs = null;
        lastCheckedID = -1;
        lastCheckedStatus = false;
    }
}

