/*
 * Decompiled with CFR 0.152.
 */
package blazingtwist.antitoolbreak.mixin;

import blazingtwist.antitoolbreak.AntiToolBreak;
import blazingtwist.antitoolbreak.config.AntiToolBreakConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public abstract class MinecraftClient_Mixin {
    @Shadow
    public class_636 field_1761;
    @Shadow
    public class_746 field_1724;

    @Unique
    private boolean shouldPreventUsage(class_1799 itemStack) {
        AntiToolBreakConfig config = AntiToolBreak.getConfig();
        if (config.sneakToBypass && this.field_1724.method_5715()) {
            return false;
        }
        if (!itemStack.method_7963()) {
            return false;
        }
        int durability = itemStack.method_7936() - itemStack.method_7919();
        if (durability > config.triggerDurability) {
            return false;
        }
        boolean isEnchanted = itemStack.method_7942();
        if (isEnchanted && config.triggerFilter_enchanted || !isEnchanted && config.triggerFilter_noEnchant) {
            return true;
        }
        return AntiToolBreak.isItemMaterialProtected(config, itemStack.method_7909());
    }

    @Inject(method={"handleBlockBreaking(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHandleBlockBreaking(boolean isBreakPressed, CallbackInfo info) {
        if (isBreakPressed && this.shouldPreventUsage(this.field_1724.method_31548().method_7391())) {
            this.field_1761.method_2925();
            info.cancel();
        }
    }

    @Inject(method={"doAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDoAttack(CallbackInfoReturnable<Boolean> info) {
        if (this.shouldPreventUsage(this.field_1724.method_31548().method_7391())) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"doItemUse()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDoItemUse(CallbackInfo info) {
        if (this.shouldPreventUsage(this.field_1724.method_31548().method_7391())) {
            info.cancel();
        }
    }
}

