/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic;

import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.type.list.SortingBlockList;
import team.creative.creativecore.common.util.type.list.SortingList;

public class ItemPhysicConfig {
    @CreativeConfig
    public General general = new General();
    @CreativeConfig
    public Pickup pickup = new Pickup();
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public Rendering rendering = new Rendering();
    @CreativeConfig(name="throw")
    public Throw throwConfig = new Throw();

    public static class General {
        @CreativeConfig
        public boolean fallSounds = true;
        @CreativeConfig
        public boolean disableCactusDamage = true;
        @CreativeConfig
        public SortingList swimmingItems = new SortingList();
        @CreativeConfig
        public SortingList burningItems = new SortingList();
        @CreativeConfig
        public SortingList undestroyableItems = new SortingList();

        public General() {
            this.swimmingItems.addSortingObjects(new Object[]{BlockTags.MINEABLE_WITH_AXE, BlockTags.LOGS, BlockTags.PLANKS, Blocks.SPONGE, Blocks.WET_SPONGE, BlockTags.ICE, BlockTags.LEAVES, BlockTags.FLOWERS, BlockTags.SMALL_FLOWERS, BlockTags.SNOW, Blocks.CACTUS, Blocks.CAKE, Blocks.COBWEB, Blocks.SNOW, Items.APPLE, Items.BOW, Items.BOWL, Items.ARROW, Items.APPLE, Items.STRING, Items.FEATHER, Items.WHEAT, Items.BREAD, Items.PAINTING, Items.ACACIA_BOAT, Items.ACACIA_DOOR, Items.DARK_OAK_BOAT, Items.DARK_OAK_DOOR, Items.BIRCH_BOAT, Items.BIRCH_DOOR, Items.JUNGLE_BOAT, Items.JUNGLE_DOOR, Items.OAK_BOAT, Items.OAK_DOOR, Items.SPRUCE_BOAT, Items.SPRUCE_DOOR, Items.SADDLE, Items.BONE, Items.SUGAR, Items.EGG, Items.FISHING_ROD, Items.CAKE, Items.MELON, Items.SHEARS, Items.CARROT, Items.POTATO, Items.POISONOUS_POTATO, Items.BAKED_POTATO, Items.PUMPKIN_PIE, Items.ELYTRA, Items.MUTTON, Items.COOKED_MUTTON, Items.RABBIT, Items.COOKED_RABBIT, Items.RABBIT_STEW, Items.BEETROOT, Items.BEETROOT_SEEDS, Items.BEETROOT_SOUP, Items.SHIELD, Items.WHEAT_SEEDS, Items.PUMPKIN_SEEDS, Items.MELON_SEEDS, Items.SNOWBALL});
            this.burningItems.addSortingObjects(new Object[]{BlockTags.MINEABLE_WITH_AXE, BlockTags.LOGS_THAT_BURN, BlockTags.PLANKS, Blocks.SPONGE, Blocks.WET_SPONGE, BlockTags.ICE, BlockTags.LEAVES, BlockTags.WOOL, BlockTags.WOOL_CARPETS, BlockTags.FLOWERS, BlockTags.SMALL_FLOWERS, BlockTags.SNOW, Blocks.CACTUS, Blocks.CAKE, Blocks.COBWEB, Blocks.SNOW, Items.APPLE, Items.BOW, Items.BOWL, Items.ARROW, Items.APPLE, Items.STRING, Items.FEATHER, Items.WHEAT, Items.BREAD, Items.LEATHER, Items.LEATHER_BOOTS, Items.LEATHER_CHESTPLATE, Items.LEATHER_HELMET, Items.LEATHER_LEGGINGS, Items.LEAD, Items.PAINTING, Items.ACACIA_BOAT, Items.ACACIA_DOOR, Items.DARK_OAK_BOAT, Items.DARK_OAK_DOOR, Items.BIRCH_BOAT, Items.BIRCH_DOOR, Items.JUNGLE_BOAT, Items.JUNGLE_DOOR, Items.OAK_BOAT, Items.OAK_DOOR, Items.SPRUCE_BOAT, Items.SPRUCE_DOOR, Items.SADDLE, Items.BONE, Items.SUGAR, Items.PAPER, Items.BOOK, Items.EGG, Items.FISHING_ROD, Items.CAKE, Items.MELON, Items.SHEARS, Items.WRITABLE_BOOK, Items.WRITTEN_BOOK, Items.CARROT, Items.POTATO, Items.POISONOUS_POTATO, Items.BAKED_POTATO, Items.MAP, Items.FILLED_MAP, Items.PUMPKIN_PIE, Items.NAME_TAG, Items.ENCHANTED_BOOK, Items.ELYTRA, Items.MUTTON, Items.COOKED_MUTTON, Items.RABBIT, Items.COOKED_RABBIT, Items.RABBIT_STEW, Items.BEETROOT, Items.BEETROOT_SEEDS, Items.BEETROOT_SOUP, Items.SHIELD, Items.WHEAT_SEEDS, Items.PUMPKIN_SEEDS, Items.MELON_SEEDS, new CreativeIngredientFuel(), Items.SPIDER_EYE, Items.ROTTEN_FLESH, Items.SNOWBALL});
            this.undestroyableItems.addSortingObjects(new Object[]{Items.NETHER_STAR, Blocks.BEDROCK, Blocks.OBSIDIAN, Blocks.BARRIER});
        }
    }

    public static class Pickup {
        @CreativeConfig
        public boolean customPickup = false;
        @CreativeConfig
        public boolean pickupWhenSneaking = true;
        @CreativeConfig
        public boolean pickupNormally = false;
        @CreativeConfig
        public double maximumPickupRange = 5.0;
        @CreativeConfig
        @CreativeConfig.DecimalRange(min=0.0, max=1.0)
        public double hitboxIncrease = 0.2;
        @CreativeConfig
        public SortingList alwaysPickup = new SortingList();
    }

    public static class Rendering {
        @CreativeConfig
        public boolean oldRotation = false;
        @CreativeConfig
        public boolean vanillaRendering = false;
        @CreativeConfig
        @CreativeConfig.DecimalRange(min=0.0, max=10.0)
        public float rotateSpeed = 1.0f;
        @CreativeConfig
        public boolean showPickupTooltip = true;
        @CreativeConfig
        public boolean showPickupTooltipExtended = false;
        @CreativeConfig
        public boolean showPickupTooltipKeybind = false;
        @CreativeConfig
        public boolean disableThrowHUD = false;
        @CreativeConfig
        public SortingList vanillaRendered = new SortingList(true);
        @CreativeConfig
        public int tooltipOffsetX = 0;
        @CreativeConfig
        public int tooltipOffsetY = 0;
        @CreativeConfig
        public SortingBlockList blockRequireOffset = new SortingBlockList().add(Blocks.SNOW).add(Blocks.SOUL_SAND).add(Blocks.MUD);
        @CreativeConfig
        public SortingBlockList blockBelowRequireOffset = new SortingBlockList();
    }

    public static class Throw {
        @CreativeConfig
        public boolean enabled = true;
        @CreativeConfig
        @CreativeConfig.IntRange(min=1, max=20)
        public int maxStages = 6;
        @CreativeConfig
        public double multiplierPerStage = 1.0;
        @CreativeConfig
        public int stageChargeTime = 10;
    }
}

