/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.client.ItemEntityRenderStateExtender;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.mixin.EntityAccessor;

public class ClientPhysic {
    private static final float baseMultiplier = 0.25f;
    private static final Minecraft MC = Minecraft.getInstance();

    public static void calculateRotation(ItemEntity entity, ItemEntityRenderState state) {
        boolean gui3d;
        Vec3 motionMultiplier;
        float rotateBy = MC.getDeltaTracker().getRealtimeDeltaTicks() * 0.25f * ItemPhysic.CONFIG.rendering.rotateSpeed;
        if (MC.isPaused()) {
            rotateBy = 0.0f;
        }
        if ((motionMultiplier = ((EntityAccessor)entity).getStuckSpeedMultiplier()) != null && motionMultiplier.lengthSqr() > 0.0) {
            rotateBy = (float)((double)rotateBy * (motionMultiplier.x * 0.2));
        }
        if (gui3d = ((ItemEntityRenderStateExtender)state).isBlock()) {
            if (!entity.onGround()) {
                rotateBy *= 2.0f;
                Fluid fluid = CommonPhysic.calculateFluid(entity);
                if (fluid == null) {
                    fluid = CommonPhysic.calculateFluid(entity, true);
                }
                if (fluid != null) {
                    rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.level());
                }
                entity.setXRot(entity.getXRot() + rotateBy);
            } else if (ItemPhysic.CONFIG.rendering.oldRotation) {
                for (int side = 0; side < 4; ++side) {
                    double rotation = side * 90;
                    double range = 5.0;
                    if (!((double)entity.getXRot() > rotation - range) || !((double)entity.getXRot() < rotation + range)) continue;
                    entity.setXRot((float)rotation);
                }
                if (entity.getXRot() != 0.0f && entity.getXRot() != 90.0f && entity.getXRot() != 180.0f && entity.getXRot() != 270.0f) {
                    double Abstand0 = Math.abs(entity.getXRot());
                    double Abstand90 = Math.abs(entity.getXRot() - 90.0f);
                    double Abstand180 = Math.abs(entity.getXRot() - 180.0f);
                    double Abstand270 = Math.abs(entity.getXRot() - 270.0f);
                    if (Abstand0 <= Abstand90 && Abstand0 <= Abstand180 && Abstand0 <= Abstand270) {
                        if (entity.getXRot() < 0.0f) {
                            entity.setXRot(entity.getXRot() + rotateBy);
                        } else {
                            entity.setXRot(entity.getXRot() - rotateBy);
                        }
                    }
                    if (Abstand90 < Abstand0 && Abstand90 <= Abstand180 && Abstand90 <= Abstand270) {
                        if (entity.getXRot() - 90.0f < 0.0f) {
                            entity.setXRot(entity.getXRot() + rotateBy);
                        } else {
                            entity.setXRot(entity.getXRot() - rotateBy);
                        }
                    }
                    if (Abstand180 < Abstand90 && Abstand180 < Abstand0 && Abstand180 <= Abstand270) {
                        if (entity.getXRot() - 180.0f < 0.0f) {
                            entity.setXRot(entity.getXRot() + rotateBy);
                        } else {
                            entity.setXRot(entity.getXRot() - rotateBy);
                        }
                    }
                    if (Abstand270 < Abstand90 && Abstand270 < Abstand180 && Abstand270 < Abstand0) {
                        if (entity.getXRot() - 270.0f < 0.0f) {
                            entity.setXRot(entity.getXRot() + rotateBy);
                        } else {
                            entity.setXRot(entity.getXRot() - rotateBy);
                        }
                    }
                }
            }
        } else if (!(entity == null || Double.isNaN(entity.getX()) || Double.isNaN(entity.getY()) || Double.isNaN(entity.getZ()) || entity.level() == null)) {
            if (entity.onGround()) {
                if (!gui3d) {
                    entity.setXRot(0.0f);
                }
            } else {
                rotateBy *= 2.0f;
                Fluid fluid = CommonPhysic.calculateFluid(entity);
                if (fluid != null) {
                    rotateBy /= 1.0f + CommonPhysic.getViscosity(fluid, entity.level());
                }
                entity.setXRot(entity.getXRot() + rotateBy);
            }
        }
    }
}

