/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.client.ItemEntityRenderStateExtender;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;
import team.creative.itemphysic.mixin.ItemStackRenderStateAccessor;
import team.creative.itemphysic.mixin.LayerRenderStateAccessor;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public class ItemPhysicClient {
    public static final KeyMapping PICKUP = new KeyMapping("key.pickup.item", InputConstants.UNKNOWN.getValue(), "key.categories.gameplay");
    public static int throwCharge;
    private static final double RANDOM_Y_OFFSET_SCALE = 0.007957747154594767;

    public static void init() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerKeybind(() -> PICKUP);
        loader.registerClientTick(ItemPhysicClient::gameTick);
        loader.registerClientRenderGui(ItemPhysicClient::renderTick);
        CreativeCoreClient.registerClientConfig((String)"itemphysic");
    }

    public static int getChargeStage() {
        return Math.min(1 + throwCharge / ItemPhysic.CONFIG.throwConfig.stageChargeTime, ItemPhysic.CONFIG.throwConfig.maxStages);
    }

    public static void gameTick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && !mc.player.getMainHandItem().isEmpty() && ItemPhysic.CONFIG.throwConfig.enabled) {
            if (mc.options.keyDrop.isDown()) {
                ++throwCharge;
            } else {
                if (throwCharge > 0) {
                    boolean dropAll = Screen.hasControlDown();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(Screen.hasControlDown(), ItemPhysicClient.getChargeStage()));
                    if (mc.player.getInventory().removeItem(mc.player.getInventory().getSelectedSlot(), dropAll && !mc.player.getInventory().getSelectedItem().isEmpty() ? mc.player.getInventory().getSelectedItem().getCount() : 1) != ItemStack.EMPTY) {
                        mc.player.swing(InteractionHand.MAIN_HAND);
                    }
                }
                throwCharge = 0;
            }
        }
    }

    public static void renderTick(Object object) {
        if (Minecraft.getInstance().screen == null) {
            ItemPhysicClient.renderTooltip((GuiGraphics)object);
        }
    }

    public static void renderTooltip(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && mc.player != null && !mc.isPaused()) {
            HitResult result;
            if (ItemPhysic.CONFIG.pickup.customPickup && (result = ItemPhysicClient.getItemInFocus((Player)mc.player)) != null && result.getType() == HitResult.Type.ENTITY) {
                ItemEntity entity;
                if (PICKUP.isDown()) {
                    ItemPhysicClient.onPlayerInteractClient((Level)mc.level, (Player)mc.player, false);
                }
                if ((entity = (ItemEntity)((EntityHitResult)result).getEntity()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip) {
                    int space = 2;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        if (ItemPhysic.CONFIG.rendering.showPickupTooltipExtended) {
                            list.addAll(entity.getItem().getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)TooltipFlag.NORMAL));
                        } else {
                            list.add((Component)entity.getItem().getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)TooltipFlag.NORMAL).get(0));
                        }
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(Component.literal((String)"ERRORED"));
                    }
                    if (ItemPhysic.CONFIG.rendering.showPickupTooltipKeybind) {
                        list.add(Component.translatable((String)"item.tooltip.pickup.keybind", (Object[])new Object[]{PICKUP.isUnbound() ? mc.options.keyUse.getTranslatedKeyMessage() : PICKUP.getTranslatedKeyMessage()}));
                    }
                    int width = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((Component)list.get(i)).getString();
                        width = Math.max(width, mc.font.width(text) + 10);
                    }
                    int n = list.size();
                    Objects.requireNonNull(mc.font);
                    int height = n * (9 + space) / 2;
                    for (int i = 0; i < list.size(); ++i) {
                        String text = ((Component)list.get(i)).getString();
                        Font font = mc.font;
                        Component component = (Component)list.get(i);
                        int n2 = mc.getWindow().getGuiScaledWidth() / 2 - mc.font.width(text) / 2 + ItemPhysic.CONFIG.rendering.tooltipOffsetX;
                        int n3 = mc.getWindow().getGuiScaledHeight() / 2 - height;
                        Objects.requireNonNull(mc.font);
                        graphics.drawString(font, component, n2, n3 + (9 + space) * i + ItemPhysic.CONFIG.rendering.tooltipOffsetY, 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.throwConfig.enabled && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwCharge > 0) {
                mc.player.displayClientMessage((Component)Component.translatable((String)"item.throw", (Object[])new Object[]{ItemPhysicClient.getChargeStage()}), true);
            }
        }
    }

    public static boolean render(ItemEntityRenderState state, PoseStack pose, MultiBufferSource buffer, int packedLight, RandomSource rand) {
        if (state.ageInTicks < 1.0f || ((ItemEntityRenderStateExtender)state).skipRendering() || ItemPhysic.CONFIG.rendering.vanillaRendering) {
            return false;
        }
        pose.pushPose();
        rand.setSeed((long)state.seed);
        int j = ItemPhysicClient.getModelCount(state.count);
        boolean gui3d = ((ItemEntityRenderStateExtender)state).isBlock();
        ItemTransform transform = ((LayerRenderStateAccessor)((ItemStackRenderStateAccessor)state.item).callFirstLayer()).getTransform();
        pose.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        pose.mulPose((Quaternionfc)Axis.ZP.rotation(((ItemEntityRenderStateExtender)state).getYRot()));
        Minecraft mc = Minecraft.getInstance();
        if (state.ageInTicks != 0.0f && (gui3d || mc.options != null)) {
            if (gui3d) {
                pose.translate(0.0, -0.2, -0.08);
            } else if (((ItemEntityRenderStateExtender)state).hasAdditionalOffset()) {
                pose.translate(0.0, 0.0, -0.14 - (double)state.bobOffset * 0.007957747154594767);
            } else {
                pose.translate(0.0, 0.0, -0.04 - (double)state.bobOffset * 0.007957747154594767);
            }
            double height = transform.scale().y();
            if (gui3d) {
                pose.translate(0.0, height, 0.0);
            }
            pose.mulPose((Quaternionfc)Axis.YP.rotation(((ItemEntityRenderStateExtender)state).getXRot()));
            if (gui3d) {
                pose.translate(0.0, -height, 0.0);
            }
        }
        if (!gui3d) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.translate(f7, f8, f9);
        }
        float f = transform.scale().x();
        float f1 = transform.scale().y();
        float f2 = transform.scale().z();
        for (int k = 0; k < j; ++k) {
            pose.pushPose();
            if (k > 0 && gui3d) {
                float f11 = (rand.nextFloat() * 2.0f - 1.0f) * f;
                float f13 = (rand.nextFloat() * 2.0f - 1.0f) * f1;
                float f10 = (rand.nextFloat() * 2.0f - 1.0f) * f2;
                pose.translate(f11, f13, f10);
            }
            state.item.render(pose, buffer, packedLight, OverlayTexture.NO_OVERLAY);
            pose.popPose();
            if (gui3d) continue;
            pose.translate(0.0f * f, 0.0f * f1, 0.09375f * f2);
        }
        pose.popPose();
        return true;
    }

    public static int getModelCount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(Level level, Player player, boolean rightClick) {
        Minecraft mc = Minecraft.getInstance();
        HitResult result = ItemPhysicClient.getItemInFocus((Player)mc.player);
        if (result != null && result.getType() == HitResult.Type.ENTITY) {
            ItemEntity entity = (ItemEntity)((EntityHitResult)result).getEntity();
            if (level.isClientSide && entity != null) {
                player.swing(InteractionHand.MAIN_HAND);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.getUUID(), rightClick));
                return true;
            }
        }
        return false;
    }

    public static boolean onPlayerInteract(Player player) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            if (!PICKUP.isUnbound()) {
                return false;
            }
            return ItemPhysicClient.onPlayerInteractClient(player.level(), player, true);
        }
        return false;
    }

    public static HitResult getItemInFocus(Player player) {
        Minecraft mc = Minecraft.getInstance();
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.getDeltaTracker().getGameTimeDeltaPartialTick(false);
        Vec3 position = player.getEyePosition(partialTicks);
        Vec3 view = player.getViewVector(partialTicks);
        if (mc.hitResult != null && mc.hitResult.getType() != HitResult.Type.MISS) {
            distance = Math.min(mc.hitResult.getLocation().distanceTo(position), distance);
        }
        return CommonPhysic.getItemInFocus(player, position, position.add(view.x * distance, view.y * distance, view.z * distance));
    }
}

