/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.ItemEntityExtender;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityExtender {
    @Shadow
    public int health;
    @Unique
    private boolean swim;
    @Unique
    private boolean burn;
    @Unique
    private Fluid fluid;

    private ItemEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurtInject(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!ItemPhysicServer.hurt((ItemEntity)this, source, amount)) {
            callback.setReturnValue((Object)false);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return ItemPhysicServer.interact((ItemEntity)this, player, hand);
    }

    protected void checkFallDamage(double height, boolean fall, BlockState state, BlockPos pos) {
        ItemEntity item = (ItemEntity)this;
        if (fall && item.fallDistance > 0.0 && ItemPhysic.CONFIG.general.fallSounds) {
            item.playSound(SoundEvents.WOOL_FALL, Math.min(1.0f, (float)item.fallDistance / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
        super.checkFallDamage(height, fall, state, pos);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> fluid, double p_204033_) {
        return CommonPhysic.updateFluidHeightAndDoFluidPushing((ItemEntity)this, fluid, p_204033_);
    }

    public void lavaHurt() {
        if (!this.fireImmune()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (this.hurtServer(serverlevel, this.damageSources().lava(), 4.0f)) {
                    serverlevel.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_BURN, this.getSoundSource(), 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
                }
            } else {
                for (int i = 0; i < 100; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), (double)this.random.nextFloat() * 0.1 - 0.05, 0.2 * this.random.nextDouble(), (double)this.random.nextFloat() * 0.1 - 0.05);
                }
            }
        }
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void playerTouchInject(Player player, CallbackInfo info) {
        if (ItemPhysicServer.playerTouch((ItemEntity)this, player)) {
            info.cancel();
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void fireImmuneInject(CallbackInfoReturnable<Boolean> info) {
        if (CommonPhysic.fireImmune((ItemEntity)this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z")}, require=1)
    public void updatePre(CallbackInfo info) {
        CommonPhysic.updatePre((ItemEntity)this, this.random);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInWater()Z"), require=1)
    public boolean isInWaterRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;isInLava()Z"), require=1)
    public boolean isInLavaRedirect(ItemEntity entity) {
        return false;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;applyGravity()V"), require=1)
    public void isNoGravityRedirect(ItemEntity entity) {
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=0)}, require=1)
    public void update(CallbackInfo info) {
        CommonPhysic.update((ItemEntity)this);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=2)
    public void setDeltaMovementRedirect(ItemEntity entity, Vec3 vec) {
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setEntityRepresentation(Lnet/minecraft/world/entity/Entity;)V")}, require=1)
    private void onSyncedDataUpdated(EntityDataAccessor<?> accessor, CallbackInfo callback) {
        this.swim = ItemPhysic.CONFIG.general.swimmingItems.canPass(this.level(), ((ItemEntity)this).getItem());
        this.burn = ItemPhysic.CONFIG.general.burningItems.canPass(this.level(), ((ItemEntity)this).getItem());
    }

    @Override
    public boolean canBurn() {
        return this.burn;
    }

    @Override
    public boolean canSwim() {
        return this.swim;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }
}

