/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.mixin;

import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.world.entity.item.ItemEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.client.ClientPhysic;
import team.creative.itemphysic.client.ItemEntityRenderStateExtender;
import team.creative.itemphysic.client.ItemEntityRendering;
import team.creative.itemphysic.mixin.ItemStackRenderStateAccessor;
import team.creative.itemphysic.mixin.LayerRenderStateAccessor;

@Mixin(value={ItemEntityRenderState.class})
public class ItemEntityRenderStateMixin
implements ItemEntityRenderStateExtender {
    @Unique
    public float rotX;
    @Unique
    public float rotY;
    @Unique
    public boolean skipRendering;
    @Unique
    public boolean additionalOffset;
    @Unique
    public boolean isBlock;

    @Override
    public float getXRot() {
        return this.rotX;
    }

    @Override
    public float getYRot() {
        return this.rotY;
    }

    @Override
    public boolean skipRendering() {
        return this.skipRendering;
    }

    @Override
    public boolean hasAdditionalOffset() {
        return this.additionalOffset;
    }

    @Override
    public boolean isBlock() {
        return this.isBlock;
    }

    @Override
    public void extractPhysic(ItemEntity entity) {
        ItemEntityRenderState state = (ItemEntityRenderState)this;
        this.isBlock = state.item.usesBlockLight() && ((LayerRenderStateAccessor)((ItemStackRenderStateAccessor)state.item).callFirstLayer()).getRenderType().getName().equals("item_entity_translucent_cull");
        ClientPhysic.calculateRotation(entity, state);
        this.skipRendering = ((ItemEntityRendering)entity).skipRendering();
        this.additionalOffset = ItemPhysic.CONFIG.rendering.blockRequireOffset.is(entity.level().getBlockState(entity.blockPosition())) || ItemPhysic.CONFIG.rendering.blockBelowRequireOffset.is(entity.level().getBlockState(entity.blockPosition().below()));
        this.rotX = entity.getXRot();
        this.rotY = entity.getYRot();
    }
}

