/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.server;

import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import team.creative.creativecore.CreativeCore;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.ItemEntityExtender;
import team.creative.itemphysic.mixin.EntityAccessor;
import team.creative.itemphysic.mixin.ItemEntityAccessor;

public class ItemPhysicServer {
    public static final ThreadLocal<Fluid> fluid = new ThreadLocal();

    public static void init() {
    }

    public static boolean playerTouch(ItemEntity item, Player player) {
        if (!(!ItemPhysic.CONFIG.pickup.customPickup || player.isCrouching() && ItemPhysic.CONFIG.pickup.pickupWhenSneaking || ItemPhysic.CONFIG.pickup.pickupNormally || ItemPhysic.CONFIG.pickup.alwaysPickup.canPass(item.level(), item.getItem()))) {
            return true;
        }
        return item.level().isClientSide || item.hasPickUpDelay();
    }

    public static void playerPickup(ItemEntity entity, Player player) {
        if (!entity.level().isClientSide) {
            if (!ItemPhysic.CONFIG.pickup.customPickup && entity.hasPickUpDelay()) {
                return;
            }
            ItemStack itemstack = entity.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            int hook = CreativeCore.utils().fireItemPickupPre(entity, player);
            if (hook == 1) {
                return;
            }
            ItemStack copy = itemstack.copy();
            ItemEntityAccessor ie = (ItemEntityAccessor)entity;
            if ((hook == 0 || !entity.hasPickUpDelay() || ItemPhysic.CONFIG.pickup.customPickup) && (ie.getTarget() == null || ie.getTarget().equals(player.getUUID())) && player.getInventory().add(itemstack)) {
                i = copy.getCount() - itemstack.getCount();
                CreativeCore.utils().fireItemPickupPost(entity, player, copy);
                player.take((Entity)entity, i);
                if (itemstack.isEmpty()) {
                    entity.discard();
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
                player.onItemPickup(entity);
            }
        }
    }

    public static InteractionResult interact(ItemEntity item, Player player, InteractionHand hand) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            ItemPhysicServer.playerPickup(item, player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean hurt(ItemEntity item, DamageSource source, float amount) {
        if (item.level().isClientSide || item.isRemoved()) {
            return false;
        }
        if (((EntityAccessor)item).callIsInvulnerableToBase(source)) {
            return false;
        }
        if (!item.getItem().isEmpty() && ItemPhysic.CONFIG.general.undestroyableItems.canPass(item.level(), item.getItem())) {
            return false;
        }
        if (!item.getItem().isEmpty() && item.getItem().getItem() == Items.NETHER_STAR && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        if (!item.getItem().canBeHurtBy(source)) {
            return false;
        }
        if ((source.is(DamageTypeTags.IS_FIRE) || source == item.damageSources().lava() || source == item.damageSources().onFire() || source == item.damageSources().inFire()) && !((ItemEntityExtender)item).canBurn()) {
            return false;
        }
        return !ItemPhysic.CONFIG.general.disableCactusDamage || source != item.damageSources().cactus();
    }
}

