/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntityCommon;
import org.cyclops.flopper.FlopperForge;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.blockentity.BlockEntityFlopperForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFlopperForge
extends BlockFlopper {
    public static final MapCodec<BlockFlopper> CODEC = BlockBehaviour.simpleCodec(properties -> new BlockFlopperForge((BlockBehaviour.Properties)properties, BlockEntityFlopperForge::new));

    public BlockFlopperForge(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntityCommon> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        InteractionResult activatedSuper = super.useWithoutItem(blockState, level, pos, player, rayTraceResult);
        if (activatedSuper.consumesAction()) {
            return activatedSuper;
        }
        return FlopperForge._instance.getModHelpers().getCapabilityHelpers().getCapability((BlockGetter)level, pos, ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> {
            if (BlockFlopperConfig.showContentsStatusMessageOnClick) {
                FluidStack fluidStack = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (fluidStack.isEmpty()) {
                    player.displayClientMessage((Component)Component.literal((String)("0 / " + String.format("%,d", fluidHandler.getTankCapacity(0)))), true);
                } else {
                    player.displayClientMessage((Component)fluidStack.getDisplayName().plainCopy().append((Component)Component.literal((String)(": " + String.format("%,d", fluidStack.getAmount()) + " / " + String.format("%,d", fluidHandler.getTankCapacity(0))))), true);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemInteractionResult activatedSuper = super.useItemOn(itemStack, blockState, level, pos, player, hand, rayTraceResult);
        if (activatedSuper.consumesAction()) {
            return activatedSuper;
        }
        int bucketVolume = FlopperForge._instance.getModHelpers().getFluidHelpers().getBucketVolume();
        return FlopperForge._instance.getModHelpers().getCapabilityHelpers().getCapability((BlockGetter)level, pos, ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> {
            if (!player.isCrouching() && BlockFlopperForge.tryEmptyContainer(itemStack, fluidHandler, bucketVolume, player, false).isSuccess()) {
                FluidActionResult result = BlockFlopperForge.tryEmptyContainer(itemStack, fluidHandler, bucketVolume, player, true);
                if (result.isSuccess()) {
                    ItemStack drainedItem = result.getResult();
                    if (!player.isCreative()) {
                        FlopperForge._instance.getModHelpers().getInventoryHelpers().tryReAddToStack(player, itemStack, drainedItem, hand);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isCrouching() && BlockFlopperForge.tryFillContainer(itemStack, fluidHandler, bucketVolume, player, false).isSuccess()) {
                FluidActionResult result = BlockFlopperForge.tryFillContainer(itemStack, fluidHandler, bucketVolume, player, true);
                if (result.isSuccess()) {
                    ItemStack filledItem = result.getResult();
                    if (!player.isCreative()) {
                        FlopperForge._instance.getModHelpers().getInventoryHelpers().tryReAddToStack(player, itemStack, filledItem, hand);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @javax.annotation.Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = container.copyWithCount(1);
        return BlockFlopperForge.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }

    @NotNull
    public static FluidActionResult tryFillContainer(@NotNull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return BlockFlopperForge.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    SoundEvent soundevent;
                    FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)true);
                    if (player != null && (soundevent = simulatedTransfer.getFluid().getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL)) != null) {
                        player.level().playSound((Player)null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().isEmpty() && event.getLevel().getBlockState(event.getPos()).getBlock() == this && BlockFlopperForge.getFluidHandler(event.getItemStack()).isPresent()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public static LazyOptional<IFluidHandlerItem> getFluidHandler(@NotNull ItemStack itemStack) {
        if (itemStack.getItem() instanceof BucketItem) {
            return LazyOptional.of(() -> new FluidBucketWrapper(itemStack));
        }
        return LazyOptional.empty();
    }
}

