/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IRenderHelpersForge;
import org.cyclops.flopper.FlopperForge;
import org.cyclops.flopper.blockentity.BlockEntityFlopperForge;
import org.jetbrains.annotations.Nullable;

public class RenderBlockEntityFlopperForge
implements BlockEntityRenderer<BlockEntityFlopperForge, RenderState> {
    public RenderBlockEntityFlopperForge(BlockEntityRendererProvider.Context context) {
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityFlopperForge blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        if (blockEntity != null) {
            renderState.fluid = blockEntity.getTank().getFluid();
            renderState.capacity = blockEntity.getTank().getCapacity();
            renderState.level = blockEntity.getLevel();
        }
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        FluidStack fluid = renderState.fluid;
        IRenderHelpersForge renderHelpers = FlopperForge._instance.getModHelpers().getRenderHelpers();
        renderHelpers.renderFluidContext(fluid, poseStack, () -> {
            float height = (float)fluid.getAmount() * 0.3125f / (float)renderState.capacity + 0.6875f;
            int brightness = Math.max(renderState.lightCoords, fluid.getFluid().getFluidType().getLightLevel(fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = renderHelpers.getFluidIcon(renderState.fluid, Direction.UP);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            Triple color = FlopperForge._instance.getModHelpers().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid.getFluid().defaultFluidState(), renderState.level, renderState.blockPos));
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.text((ResourceLocation)icon.atlasLocation()), (pose, vb) -> {
                vb.addVertex(pose, 0.125f, height, 0.125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                vb.addVertex(pose, 0.125f, height, 0.875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(pose, 0.875f, height, 0.875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(pose, 0.875f, height, 0.125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            });
        });
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public FluidStack fluid = FluidStack.EMPTY;
        public int capacity = 0;
        public BlockAndTintGetter level;
    }
}

