/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3737;
import org.cyclops.cyclopscore.helper.IModHelpersFabric;
import org.cyclops.flopper.FlopperFabric;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.block.BlockFlopperConfigFabric;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;
import org.cyclops.flopper.blockentity.FluidStorageBlockFabricExtractable;
import org.cyclops.flopper.blockentity.FluidStorageBlockFabricInsertable;

public class BlockEntityFlopperFabric
extends BlockEntityFlopper {
    private SingleVariantStorage<FluidVariant> tank = new SingleVariantStorage<FluidVariant>(){

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return BlockFlopperConfigFabric.capacityDroplets;
        }

        protected void onFinalCommit() {
            super.onFinalCommit();
            BlockEntityFlopperFabric.this.sendUpdate();
            BlockEntityFlopperFabric.this.onDirty();
        }
    };

    public BlockEntityFlopperFabric(class_2338 blockPos, class_2680 blockState) {
        super(blockPos, blockState);
    }

    public SingleVariantStorage<FluidVariant> getTank() {
        return this.tank;
    }

    public void read(class_11368 input) {
        super.read(input);
        SingleVariantStorage.readData(this.getTank(), (Codec)FluidVariant.CODEC, FluidVariant::blank, (class_11368)input);
    }

    public void method_11007(class_11372 output) {
        super.method_11007(output);
        SingleVariantStorage.writeData(this.getTank(), (Codec)FluidVariant.CODEC, (class_11372)output);
    }

    @Override
    protected boolean pushFluidsToTank() {
        class_2350 targetSide = this.getFacing().method_10153();
        class_2338 targetPos = this.method_11016().method_10093(this.getFacing());
        Storage target = (Storage)FluidStorage.SIDED.find(this.field_11863, targetPos, (Object)targetSide);
        if (target == null) {
            return false;
        }
        return FlopperFabric._instance.getModHelpers().getFluidHelpers().moveFluid(this.getTank(), target, (long)BlockFlopperConfigFabric.pushFluidRateDroplets) > 0L;
    }

    @Override
    protected boolean pullFluidsFromTank() {
        class_2338 targetPos = this.method_11016().method_10093(class_2350.field_11036);
        Storage source = (Storage)FluidStorage.SIDED.find(this.field_11863, targetPos, (Object)class_2350.field_11033);
        if (source == null) {
            return false;
        }
        return FlopperFabric._instance.getModHelpers().getFluidHelpers().moveFluid(source, this.getTank(), (long)BlockFlopperConfigFabric.pullFluidRateDroplets) > 0L;
    }

    @Override
    protected boolean pushFluidsToWorld() {
        boolean isDestReplaceable;
        class_2338 targetPos = this.method_11016().method_10093(this.getFacing());
        class_2680 destBlockState = this.field_11863.method_8320(targetPos);
        boolean isDestNonSolid = !destBlockState.method_51367();
        boolean bl = isDestReplaceable = destBlockState.method_26223() == class_3619.field_15971;
        if (this.field_11863.method_22347(targetPos) || isDestNonSolid && isDestReplaceable && !destBlockState.method_51176()) {
            return this.getFluidBlockHandler(this.field_11863, targetPos, (FluidVariant)this.tank.variant).map(target -> {
                long moved = FlopperFabric._instance.getModHelpers().getFluidHelpers().moveFluid(this.getTank(), (Storage)target, this.tank.amount);
                if (moved > 0L) {
                    class_3414 soundevent;
                    if (BlockFlopperConfig.worldPullPushSounds && (soundevent = FluidVariantAttributes.getFillSound((FluidVariant)((FluidVariant)target.variant))) != null) {
                        this.field_11863.method_8396(null, this.field_11867, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                        this.field_11863.method_8492(this.field_11867, class_2246.field_10124, null);
                    }
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private Optional<FluidStorageBlockFabricInsertable> getFluidBlockHandler(class_1937 world, class_2338 targetPos, FluidVariant fluidVariant) {
        if (world.method_8597().comp_644() && fluidVariant.getFluid().method_15780((class_3611)class_3612.field_15910)) {
            return Optional.empty();
        }
        class_2680 state = fluidVariant.getFluid().method_15785().method_15759();
        return Optional.of(new FluidStorageBlockFabricInsertable(state, world, targetPos, fluidVariant));
    }

    @Override
    protected boolean pullFluidsFromWorld() {
        class_2338 targetPos = this.method_11016().method_10093(class_2350.field_11036);
        class_2680 destBlockState = this.field_11863.method_8320(targetPos);
        return this.wrapFluidBlock(destBlockState, this.field_11863, targetPos).map(source -> {
            long moved = FlopperFabric._instance.getModHelpers().getFluidHelpers().moveFluid(source, this.getTank(), Integer.MAX_VALUE);
            if (moved > 0L) {
                class_3414 soundevent;
                if (BlockFlopperConfig.worldPullPushSounds && (soundevent = FluidVariantAttributes.getEmptySound((FluidVariant)((FluidVariant)this.getTank().variant))) != null) {
                    this.field_11863.method_8396(null, this.field_11867, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                    this.field_11863.method_8492(this.field_11867, class_2246.field_10124, null);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    protected boolean isTankEmpty() {
        return this.getTank().isResourceBlank();
    }

    @Override
    protected boolean isTankFull() {
        return this.getTank().getAmount() == this.getTank().getCapacity();
    }

    @Override
    public int getFluidAmount() {
        return (int)this.getTank().getAmount();
    }

    @Override
    public int getFluidCapacity() {
        return (int)this.getTank().getCapacity();
    }

    @Override
    public boolean hasBucket() {
        return this.getTank().getAmount() == (long)IModHelpersFabric.get().getFluidHelpers().getBucketVolume();
    }

    private Optional<Storage<FluidVariant>> wrapFluidBlock(class_2680 blockState, class_1937 world, class_2338 targetPos) {
        if (blockState.method_26204() instanceof class_2404 || blockState.method_26204() instanceof class_3737) {
            return Optional.of(new FluidStorageBlockFabricExtractable(blockState, world, targetPos));
        }
        return Optional.empty();
    }
}

