/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import org.cyclops.cyclopscore.fluid.SingleUseTankForge;
import org.cyclops.cyclopscore.fluid.TankForge;
import org.cyclops.cyclopscore.helper.IModHelpersForge;
import org.cyclops.flopper.FlopperForge;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;
import org.cyclops.flopper.blockentity.FluidHandlerBlockForge;

public class BlockEntityFlopperForge
extends BlockEntityFlopper {
    private TankForge tank = new SingleUseTankForge(BlockFlopperConfig.capacityMb){

        protected void sendUpdate() {
            super.sendUpdate();
            BlockEntityFlopperForge.this.sendUpdate();
            BlockEntityFlopperForge.this.onDirty();
        }
    };
    private final LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.tank);

    public BlockEntityFlopperForge(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public TankForge getTank() {
        return this.tank;
    }

    public void read(ValueInput input) {
        super.read(input);
        this.tank.readFromNBT((CompoundTag)input.read("tank", ExtraCodecs.NBT).orElseThrow());
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        CompoundTag tagTank = new CompoundTag();
        this.tank.writeToNBT(tagTank);
        output.store("tank", ExtraCodecs.NBT, (Object)tagTank);
    }

    @Override
    protected boolean pushFluidsToTank() {
        Direction targetSide = this.getFacing().getOpposite();
        BlockPos targetPos = this.getBlockPos().relative(this.getFacing());
        return FlopperForge._instance.getModHelpers().getCapabilityHelpers().getCapability((BlockGetter)this.level, targetPos, targetSide, ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)BlockFlopperConfig.pushFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    protected boolean pullFluidsFromTank() {
        BlockPos targetPos = this.getBlockPos().relative(Direction.UP);
        return FlopperForge._instance.getModHelpers().getCapabilityHelpers().getCapability((BlockGetter)this.level, targetPos, Direction.DOWN, ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)BlockFlopperConfig.pullFluidRate, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    protected boolean pushFluidsToWorld() {
        boolean isDestReplaceable;
        BlockPos targetPos = this.getBlockPos().relative(this.getFacing());
        BlockState destBlockState = this.level.getBlockState(targetPos);
        boolean isDestNonSolid = !destBlockState.isSolid();
        boolean bl = isDestReplaceable = destBlockState.getPistonPushReaction() == PushReaction.DESTROY;
        if (this.level.isEmptyBlock(targetPos) || isDestNonSolid && isDestReplaceable && !destBlockState.liquid()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (!this.level.dimensionType().ultraWarm() || !fluidStack.getFluid().getFluidType().isVaporizedOnPlacement(this.level, this.worldPosition, fluidStack)) {
                return this.getFluidBlockHandler(fluidStack.getFluid(), this.level, targetPos).map(fluidHandler -> {
                    FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)Integer.MAX_VALUE, (boolean)true);
                    if (!moved.isEmpty()) {
                        SoundEvent soundevent;
                        if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_FILL)) != null) {
                            this.level.playSound(null, this.worldPosition, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                            this.level.neighborChanged(this.worldPosition, Blocks.AIR, null);
                        }
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        return false;
    }

    private Optional<IFluidHandler> getFluidBlockHandler(Fluid fluid, Level world, BlockPos targetPos) {
        if (!fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)world, targetPos, fluid.defaultFluidState())) {
            return Optional.empty();
        }
        BlockState state = fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)world, targetPos, fluid.defaultFluidState());
        return Optional.of(new BlockWrapper(state, world, targetPos));
    }

    @Override
    protected boolean pullFluidsFromWorld() {
        BlockPos targetPos = this.getBlockPos().relative(Direction.UP);
        BlockState destBlockState = this.level.getBlockState(targetPos);
        return this.wrapFluidBlock(destBlockState, this.level, targetPos).map(fluidHandler -> {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
            if (!moved.isEmpty()) {
                SoundEvent soundevent;
                if (BlockFlopperConfig.worldPullPushSounds && (soundevent = moved.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                    this.level.playSound(null, this.worldPosition, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (BlockFlopperConfig.worldPullPushNeighbourEvents) {
                    this.level.neighborChanged(this.worldPosition, Blocks.AIR, null);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    protected boolean isTankEmpty() {
        return this.getTank().isEmpty();
    }

    @Override
    protected boolean isTankFull() {
        return this.getTank().isFull();
    }

    @Override
    public int getFluidAmount() {
        return this.getTank().getFluidAmount();
    }

    @Override
    public int getFluidCapacity() {
        return this.getTank().getCapacity();
    }

    @Override
    public boolean hasBucket() {
        return this.getTank().getFluidAmount() == IModHelpersForge.get().getFluidHelpers().getBucketVolume();
    }

    private Optional<IFluidHandler> wrapFluidBlock(BlockState blockState, Level world, BlockPos targetPos) {
        if (blockState.getBlock() instanceof LiquidBlock || blockState.getBlock() instanceof SimpleWaterloggedBlock) {
            return Optional.of(new FluidHandlerBlockForge(blockState, world, targetPos));
        }
        return Optional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCapability.invalidate();
    }
}

