/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.client.render.blockentity;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IRenderHelpersFabric;
import org.cyclops.flopper.FlopperFabric;
import org.cyclops.flopper.blockentity.BlockEntityFlopperFabric;
import org.jetbrains.annotations.Nullable;

public class RenderBlockEntityFlopperFabric
implements class_827<BlockEntityFlopperFabric, RenderState> {
    public RenderBlockEntityFlopperFabric(class_5614.class_5615 context) {
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityFlopperFabric blockEntity, RenderState renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        if (blockEntity != null) {
            renderState.fluid = (FluidVariant)blockEntity.getTank().getResource();
            renderState.fluidAmount = blockEntity.getTank().getAmount();
            renderState.capacity = blockEntity.getTank().getCapacity();
            renderState.level = blockEntity.method_10997();
        }
    }

    public void submit(RenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        FluidVariant fluid = renderState.fluid;
        long amount = renderState.fluidAmount;
        IRenderHelpersFabric renderHelpers = FlopperFabric._instance.getModHelpers().getRenderHelpers();
        renderHelpers.renderFluidContext(fluid, poseStack, () -> {
            float height = (float)amount * 0.3125f / (float)renderState.capacity + 0.6875f;
            int brightness = Math.max(renderState.field_62676, FluidVariantAttributes.getLuminance((FluidVariant)fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            class_1058 icon = renderHelpers.getFluidIcon(fluid, class_2350.field_11036);
            Triple color = renderHelpers.getFluidVertexBufferColor(fluid);
            submitNodeCollector.method_73483(poseStack, class_1921.method_23028((class_2960)icon.method_45852()), (pose, vb) -> {
                vb.method_56824(pose, 0.125f, height, 0.125f).method_22915(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).method_22913(icon.method_4594(), icon.method_4575()).method_22921(l2, i3);
                vb.method_56824(pose, 0.125f, height, 0.875f).method_22915(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).method_22913(icon.method_4594(), icon.method_4593()).method_22921(l2, i3);
                vb.method_56824(pose, 0.875f, height, 0.875f).method_22915(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).method_22913(icon.method_4577(), icon.method_4593()).method_22921(l2, i3);
                vb.method_56824(pose, 0.875f, height, 0.125f).method_22915(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).method_22913(icon.method_4577(), icon.method_4575()).method_22921(l2, i3);
            });
        });
    }

    public static class RenderState
    extends class_11954 {
        public FluidVariant fluid = FluidVariant.blank();
        public long fluidAmount = 0L;
        public long capacity = 0L;
        public class_1920 level;
    }
}

