/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopper;
import org.cyclops.flopper.block.BlockFlopperConfig;

public abstract class BlockEntityFlopper
extends CyclopsBlockEntity {
    @NBTPersist
    private int transferCooldown = -1;

    public BlockEntityFlopper(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)RegistryEntries.BLOCK_ENTITY_FLOPPER.comp_349(), blockPos, blockState);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public int getTransferCooldown() {
        return this.transferCooldown;
    }

    protected class_2350 getFacing() {
        return (class_2350)this.method_10997().method_8320(this.method_11016()).method_11654(BlockFlopper.FACING);
    }

    protected abstract boolean pushFluidsToTank();

    protected abstract boolean pullFluidsFromTank();

    protected abstract boolean pushFluidsToWorld();

    protected abstract boolean pullFluidsFromWorld();

    protected abstract boolean isTankEmpty();

    protected abstract boolean isTankFull();

    public abstract int getFluidAmount();

    public abstract int getFluidCapacity();

    public abstract boolean hasBucket();

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityFlopper> {
        protected void update(class_1937 level, class_2338 pos, class_2680 blockState, BlockEntityFlopper blockEntity) {
            super.update(level, pos, blockState, (class_2586)blockEntity);
            if (level != null && !level.field_9236) {
                blockEntity.setTransferCooldown(blockEntity.getTransferCooldown() - 1);
                if (!this.isOnTransferCooldown(blockEntity)) {
                    blockEntity.setTransferCooldown(0);
                    this.updateHopper(level, pos, blockState, blockEntity);
                }
            }
        }

        private boolean isOnTransferCooldown(BlockEntityFlopper blockEntity) {
            return blockEntity.getTransferCooldown() > 0;
        }

        protected boolean updateHopper(class_1937 level, class_2338 pos, class_2680 blockState, BlockEntityFlopper blockEntity) {
            if (level != null && !level.field_9236) {
                if (!this.isOnTransferCooldown(blockEntity) && ((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (class_2769)BlockFlopper.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                    boolean worked = false;
                    boolean workedWorld = false;
                    if (!blockEntity.isTankEmpty()) {
                        boolean bl = BlockFlopperConfig.pushFluidRate > 0 && blockEntity.pushFluidsToTank() || (workedWorld = BlockFlopperConfig.pushFluidsWorld && blockEntity.pushFluidsToWorld()) ? true : (worked = false);
                    }
                    if (!blockEntity.isTankFull()) {
                        boolean bl = BlockFlopperConfig.pullFluidRate > 0 && blockEntity.pullFluidsFromTank() || (workedWorld = BlockFlopperConfig.pullFluidsWorld && blockEntity.pullFluidsFromWorld() || workedWorld) || worked ? true : (worked = false);
                    }
                    if (worked) {
                        blockEntity.setTransferCooldown(workedWorld ? BlockFlopperConfig.workWorldCooldown : BlockFlopperConfig.workCooldown);
                        blockEntity.method_5431();
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

