/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.flopper.FlopperNeoForge;

public class FluidHandlerBlockNeoForge
implements IFluidHandler {
    private final BlockState state;
    private final Level world;
    private final BlockPos blockPos;

    public FluidHandlerBlockNeoForge(BlockState state, Level world, BlockPos blockPos) {
        this.state = state;
        this.world = world;
        this.blockPos = blockPos;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Block block = this.state.getBlock();
        if (block instanceof LiquidBlock && (Integer)this.state.getValue((Property)LiquidBlock.LEVEL) == 0) {
            return new FluidStack((Fluid)((LiquidBlock)block).fluid, FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume());
        }
        if (this.state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)this.state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return new FluidStack((Fluid)Fluids.WATER, FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume());
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        Block block = this.state.getBlock();
        if (block instanceof LiquidBlock && ((LiquidBlock)block).fluid == resource.getFluid()) {
            return this.drain(resource.getAmount(), action);
        }
        if (this.state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)this.state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && block instanceof SimpleWaterloggedBlock) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Block block = this.state.getBlock();
        if (block instanceof LiquidBlock && (Integer)this.state.getValue((Property)LiquidBlock.LEVEL) == 0 && maxDrain >= FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume()) {
            if (action.execute()) {
                this.world.setBlock(this.blockPos, Blocks.AIR.defaultBlockState(), 11);
            }
            return new FluidStack((Fluid)((LiquidBlock)block).fluid, FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume());
        }
        if (this.state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)this.state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && block instanceof SimpleWaterloggedBlock && maxDrain >= FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume()) {
            if (action.execute()) {
                ((SimpleWaterloggedBlock)block).pickupBlock(null, (LevelAccessor)this.world, this.blockPos, this.state);
            }
            return new FluidStack((Fluid)Fluids.WATER, FlopperNeoForge._instance.getModHelpers().getFluidHelpers().getBucketVolume());
        }
        return FluidStack.EMPTY;
    }
}

