/*
 * Decompiled with CFR 0.152.
 */
package com.shim.decorandmore.blocks;

import com.shim.decorandmore.blocks.IRedstoneWeatheringBlock;
import com.shim.decorandmore.blocks.IWeatheringBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class CopperLanternBlock
extends LanternBlock
implements IRedstoneWeatheringBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private final WeatheringCopper.WeatherState weatherState;
    private final boolean redstonePowered;

    public CopperLanternBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        this(weatherState, false, properties);
    }

    public CopperLanternBlock(WeatheringCopper.WeatherState weatherState, Boolean redstonePowered, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = weatherState;
        this.redstonePowered = redstonePowered;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_153459_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_153460_, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7455_(BlockState p_154929_, ServerLevel p_154930_, BlockPos p_154931_, Random p_154932_) {
        this.m_153041_(p_154929_, p_154930_, p_154931_, p_154932_);
    }

    @Override
    public boolean isRedstonePowered() {
        return this.redstonePowered;
    }

    public boolean m_6724_(BlockState p_154935_) {
        return IWeatheringBlock.getNext(p_154935_.m_60734_()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_153459_, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)f_153460_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6861_(BlockState p_55666_, Level p_55667_, BlockPos p_55668_, Block p_55669_, BlockPos p_55670_, boolean p_55671_) {
        boolean flag;
        if (!p_55667_.f_46443_ && (flag = ((Boolean)p_55666_.m_61143_((Property)LIT)).booleanValue()) != p_55667_.m_46753_(p_55668_)) {
            if (flag) {
                p_55667_.m_186460_(p_55668_, (Block)this, 4);
            } else {
                p_55667_.m_7731_(p_55668_, (BlockState)p_55666_.m_61122_((Property)LIT), 2);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel p_55662_, BlockPos p_55663_, Random p_55664_) {
        Block block = state.m_60734_();
        if (block instanceof CopperLanternBlock) {
            CopperLanternBlock lantern = (CopperLanternBlock)block;
            if (lantern.redstonePowered && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !p_55662_.m_46753_(p_55663_)) {
                p_55662_.m_7731_(p_55663_, (BlockState)state.m_61122_((Property)LIT), 2);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_153490_) {
        p_153490_.m_61104_(new Property[]{f_153459_, f_153460_, LIT});
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActions.AXE_SCRAPE) {
            return IWeatheringBlock.getPrevious(state).orElse(null);
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }
}

