/*
 * Decompiled with CFR 0.152.
 */
package com.shim.decorandmore.blocks;

import com.shim.decorandmore.util.WeatheringUtil;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;

public interface IWeatheringBlock
extends ChangeOverTimeBlock<WeatheringCopper.WeatherState> {
    public static Block getFirst(Block blockIn) {
        Block block = blockIn;
        Block block1 = WeatheringUtil.WEATHERABLE_BLOCK_STAGES.get(blockIn).previousStage();
        while (block1 != null) {
            block = block1;
            block1 = WeatheringUtil.WEATHERABLE_BLOCK_STAGES.get(block1).previousStage();
        }
        return block;
    }

    public static Optional<BlockState> getPrevious(BlockState state) {
        return IWeatheringBlock.getPrevious(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getPrevious(Block block) {
        WeatheringUtil.WeatherableStage stage = WeatheringUtil.WEATHERABLE_BLOCK_STAGES.get(block);
        if (stage != null) {
            return Optional.ofNullable(stage.previousStage());
        }
        return Optional.empty();
    }

    public static Optional<Block> getNext(Block block) {
        WeatheringUtil.WeatherableStage stage = WeatheringUtil.WEATHERABLE_BLOCK_STAGES.get(block);
        if (stage != null) {
            return Optional.ofNullable(stage.nextStage());
        }
        return Optional.empty();
    }

    public static BlockState getFirst(BlockState state) {
        return IWeatheringBlock.getFirst(state.m_60734_()).m_152465_(state);
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return IWeatheringBlock.getNext(state.m_60734_()).map(p_154896_ -> p_154896_.m_152465_(state));
    }

    default public float m_142377_() {
        return this.m_142297_() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }
}

