/*
 * Decompiled with CFR 0.152.
 */
package com.shim.decorandmore.blocks;

import com.google.common.collect.Sets;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RedstoneChainBlock
extends ChainBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final Vec3[] COLORS = (Vec3[])Util.m_137469_((Object)new Vec3[16], p_154319_ -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            p_154319_[i] = new Vec3((double)f1, (double)f2, (double)f3);
        }
    });
    boolean shouldSignal;

    public RedstoneChainBlock(BlockBehaviour.Properties p_51452_) {
        super(p_51452_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51446_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51468_) {
        p_51468_.m_61104_(new Property[]{f_51446_}).m_61104_(new Property[]{f_55923_}).m_61104_(new Property[]{POWER});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        if (!p_60569_.m_60713_(state.m_60734_()) && !level.f_46443_) {
            this.updatePowerStrength(level, pos, state, false);
            for (Direction direction : Direction.values()) {
                level.m_46672_(pos.m_142300_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(level, pos);
        }
    }

    public int m_6376_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return !this.shouldSignal ? 0 : state.m_60746_(getter, pos, direction);
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        if (this.shouldSignal) {
            int i = (Integer)state.m_61143_((Property)POWER);
            if (i == 0) {
                return 0;
            }
            if (((Direction.Axis)state.m_61143_((Property)f_55923_)).m_122478_()) {
                return direction == Direction.UP || direction == Direction.DOWN ? i : 0;
            }
            if (state.m_61143_((Property)f_55923_) == Direction.Axis.X) {
                return direction == Direction.WEST || direction == Direction.EAST ? i : 0;
            }
            if (state.m_61143_((Property)f_55923_) == Direction.Axis.Z) {
                return direction == Direction.NORTH || direction == Direction.SOUTH ? i : 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean m_7899_(BlockState p_55636_) {
        return this.shouldSignal;
    }

    public void m_6810_(BlockState p_55568_, Level p_55569_, BlockPos p_55570_, BlockState p_55571_, boolean p_55572_) {
        if (!p_55572_ && !p_55568_.m_60713_(p_55571_.m_60734_())) {
            super.m_6810_(p_55568_, p_55569_, p_55570_, p_55571_, p_55572_);
            if (!p_55569_.f_46443_) {
                for (Direction direction : Direction.values()) {
                    p_55569_.m_46672_(p_55570_.m_142300_(direction), (Block)this);
                }
                this.updatePowerStrength(p_55569_, p_55570_, p_55568_, true);
                this.updateNeighborsOfNeighboringWires(p_55569_, p_55570_);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level p_55638_, BlockPos p_55639_) {
        for (Direction direction : Direction.values()) {
            this.checkCornerChangeAt(p_55638_, p_55639_.m_142300_(direction));
        }
        for (Direction direction1 : Direction.values()) {
            BlockPos blockpos = p_55639_.m_142300_(direction1);
            if (p_55638_.m_8055_(blockpos).m_60796_((BlockGetter)p_55638_, blockpos)) {
                this.checkCornerChangeAt(p_55638_, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(p_55638_, blockpos.m_7495_());
        }
    }

    private void checkCornerChangeAt(Level p_55617_, BlockPos p_55618_) {
        if (p_55617_.m_8055_(p_55618_).m_60713_((Block)this)) {
            p_55617_.m_46672_(p_55618_, (Block)this);
            for (Direction direction : Direction.values()) {
                p_55617_.m_46672_(p_55618_.m_142300_(direction), (Block)this);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block p_55564_, BlockPos neighborPos, boolean p_55566_) {
        if (!level.f_46443_) {
            this.updatePowerStrength(level, pos, state, false);
        }
    }

    public List<Direction> getDirectionsToUpdate(BlockState state) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (((Direction.Axis)state.m_61143_((Property)f_55923_)).m_122478_()) {
            directions.add(Direction.UP);
            directions.add(Direction.DOWN);
        } else if (state.m_61143_((Property)f_55923_) == Direction.Axis.X) {
            directions.add(Direction.WEST);
            directions.add(Direction.NORTH);
        } else {
            directions.add(Direction.NORTH);
            directions.add(Direction.SOUTH);
        }
        return directions;
    }

    private void updatePowerStrength(Level level, BlockPos pos, BlockState state, boolean onRemove) {
        int i = this.calculateTargetStrength(level, pos, onRemove);
        if ((Integer)state.m_61143_((Property)POWER) != i) {
            if (level.m_8055_(pos) == state && !level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            if (onRemove) {
                for (Direction direction : Direction.values()) {
                    set.add(pos.m_142300_(direction));
                }
            } else {
                for (Direction direction : this.getDirectionsToUpdate(state)) {
                    set.add(pos.m_142300_(direction));
                }
            }
            for (BlockPos blockpos : set) {
                level.m_46672_(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level level, BlockPos pos, boolean onRemove) {
        this.shouldSignal = false;
        int i = level.m_46755_(pos);
        this.shouldSignal = true;
        int j = 0;
        if (i < 15) {
            List<Direction> directions = onRemove ? Arrays.stream(Direction.values()).toList() : this.getDirectionsToUpdate(level.m_8055_(pos));
            for (Direction direction : directions) {
                BlockPos relativePos = pos.m_142300_(direction);
                BlockState relativeState = level.m_8055_(relativePos);
                j = Math.max(j, this.getWireSignal(relativeState));
                BlockPos above = pos.m_7494_();
                if (relativeState.m_60796_((BlockGetter)level, relativePos)) {
                    j = Math.max(j, this.getWireSignal(level.m_8055_(relativePos.m_7494_())));
                    continue;
                }
                if (relativeState.m_60796_((BlockGetter)level, relativePos)) continue;
                j = Math.max(j, this.getWireSignal(level.m_8055_(relativePos.m_7495_())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getWireSignal(BlockState state) {
        return state.m_60713_((Block)this) ? (Integer)state.m_61143_((Property)POWER) : 0;
    }

    public static int getColorForPower(int p_55607_) {
        Vec3 vec3 = COLORS[p_55607_];
        return Mth.m_14159_((float)((float)vec3.m_7096_()), (float)((float)vec3.m_7098_()), (float)((float)vec3.m_7094_()));
    }

    private void spawnParticlesAlongLine(Level p_154310_, Random p_154311_, BlockPos p_154312_, Vec3 p_154313_, Direction p_154314_, Direction p_154315_, float p_154316_, float p_154317_) {
        float f = p_154317_ - p_154316_;
        if (!(p_154311_.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = p_154316_ + f * p_154311_.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)p_154314_.m_122429_()) + (double)(f2 * (float)p_154315_.m_122429_());
            double d1 = 0.5 + (double)(0.4375f * (float)p_154314_.m_122430_()) + (double)(f2 * (float)p_154315_.m_122430_());
            double d2 = 0.5 + (double)(0.4375f * (float)p_154314_.m_122431_()) + (double)(f2 * (float)p_154315_.m_122431_());
            p_154310_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(p_154313_), 1.0f), (double)p_154312_.m_123341_() + d0, (double)p_154312_.m_123342_() + d1, (double)p_154312_.m_123343_() + d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_7100_(BlockState p_55574_, Level p_55575_, BlockPos p_55576_, Random p_55577_) {
        int i = (Integer)p_55574_.m_61143_((Property)POWER);
        if (i != 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.spawnParticlesAlongLine(p_55575_, p_55577_, p_55576_, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }
}

