/*
 * Decompiled with CFR 0.152.
 */
package com.shim.decorandmore.datagen;

import com.shim.decorandmore.blocks.CopperLanternBlock;
import com.shim.decorandmore.blocks.HalfBlock;
import com.shim.decorandmore.blocks.LogTableBlock;
import com.shim.decorandmore.blocks.RedstoneChainBlock;
import com.shim.decorandmore.blocks.RedstoneLanternBlock;
import com.shim.decorandmore.blocks.SlabStoolBlock;
import com.shim.decorandmore.blocks.TableBlock;
import com.shim.decorandmore.registry.DecorBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DecorBlockstates
extends BlockStateProvider {
    public DecorBlockstates(DataGenerator gen, ExistingFileHelper helper) {
        super(gen, "decorandmore", helper);
    }

    protected void registerStatesAndModels() {
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.OAK_STOOL.get(), "oak");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.DARK_OAK_STOOL.get(), "dark_oak");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.JUNGLE_STOOL.get(), "jungle");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.SPRUCE_STOOL.get(), "spruce");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.ACACIA_STOOL.get(), "acacia");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.BIRCH_STOOL.get(), "birch");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.WARPED_STOOL.get(), "warped");
        this.slabStoolPlanksBlock((SlabBlock)DecorBlocks.CRIMSON_STOOL.get(), "crimson");
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.OAK_LOG_STOOL.get(), Blocks.f_49999_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.DARK_OAK_LOG_STOOL.get(), Blocks.f_50004_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.JUNGLE_LOG_STOOL.get(), Blocks.f_50002_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.SPRUCE_LOG_STOOL.get(), Blocks.f_50000_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.ACACIA_LOG_STOOL.get(), Blocks.f_50003_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.BIRCH_LOG_STOOL.get(), Blocks.f_50001_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.WARPED_STEM_STOOL.get(), Blocks.f_50686_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.CRIMSON_STEM_STOOL.get(), Blocks.f_50695_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_OAK_LOG_STOOL.get(), Blocks.f_50010_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_DARK_OAK_LOG_STOOL.get(), Blocks.f_50009_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_JUNGLE_LOG_STOOL.get(), Blocks.f_50007_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_SPRUCE_LOG_STOOL.get(), Blocks.f_50005_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_ACACIA_LOG_STOOL.get(), Blocks.f_50008_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_BIRCH_LOG_STOOL.get(), Blocks.f_50006_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_WARPED_STEM_STOOL.get(), Blocks.f_50687_);
        this.slabStoolLogBlock((SlabBlock)DecorBlocks.STRIPPED_CRIMSON_STEM_STOOL.get(), Blocks.f_50696_);
        this.logBench((StairBlock)DecorBlocks.OAK_BENCH.get(), Blocks.f_49999_, Blocks.f_50010_);
        this.logBench((StairBlock)DecorBlocks.DARK_OAK_BENCH.get(), Blocks.f_50004_, Blocks.f_50009_);
        this.logBench((StairBlock)DecorBlocks.SPRUCE_BENCH.get(), Blocks.f_50000_, Blocks.f_50005_);
        this.logBench((StairBlock)DecorBlocks.JUNGLE_BENCH.get(), Blocks.f_50002_, Blocks.f_50007_);
        this.logBench((StairBlock)DecorBlocks.ACACIA_BENCH.get(), Blocks.f_50003_, Blocks.f_50008_);
        this.logBench((StairBlock)DecorBlocks.BIRCH_BENCH.get(), Blocks.f_50001_, Blocks.f_50006_);
        this.logBench((StairBlock)DecorBlocks.WARPED_BENCH.get(), Blocks.f_50686_, Blocks.f_50687_);
        this.logBench((StairBlock)DecorBlocks.CRIMSON_BENCH.get(), Blocks.f_50695_, Blocks.f_50696_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_OAK_BENCH.get()), Blocks.f_49999_, Blocks.f_50010_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_DARK_OAK_BENCH.get()), Blocks.f_50004_, Blocks.f_50009_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_SPRUCE_BENCH.get()), Blocks.f_50000_, Blocks.f_50005_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_JUNGLE_BENCH.get()), Blocks.f_50002_, Blocks.f_50007_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_ACACIA_BENCH.get()), Blocks.f_50003_, Blocks.f_50008_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_BIRCH_BENCH.get()), Blocks.f_50001_, Blocks.f_50006_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_WARPED_BENCH.get()), Blocks.f_50686_, Blocks.f_50687_);
        this.halfLogBench((HalfBlock)((Object)DecorBlocks.HALF_CRIMSON_BENCH.get()), Blocks.f_50695_, Blocks.f_50696_);
        this.lantern((LanternBlock)DecorBlocks.GOLD_LANTERN.get());
        this.lantern((LanternBlock)DecorBlocks.GOLD_SOUL_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.COPPER_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.COPPER_SOUL_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.EXPOSED_COPPER_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.EXPOSED_COPPER_SOUL_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.WEATHERED_COPPER_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.WEATHERED_COPPER_SOUL_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.OXIDIZED_COPPER_LANTERN.get());
        this.copperLantern((CopperLanternBlock)DecorBlocks.OXIDIZED_COPPER_SOUL_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_COPPER_LANTERN.get(), (LanternBlock)DecorBlocks.COPPER_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_COPPER_SOUL_LANTERN.get(), (LanternBlock)DecorBlocks.COPPER_SOUL_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_EXPOSED_COPPER_LANTERN.get(), (LanternBlock)DecorBlocks.EXPOSED_COPPER_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_EXPOSED_COPPER_SOUL_LANTERN.get(), (LanternBlock)DecorBlocks.EXPOSED_COPPER_SOUL_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_WEATHERED_COPPER_LANTERN.get(), (LanternBlock)DecorBlocks.WEATHERED_COPPER_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_WEATHERED_COPPER_SOUL_LANTERN.get(), (LanternBlock)DecorBlocks.WEATHERED_COPPER_SOUL_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_OXIDIZED_COPPER_LANTERN.get(), (LanternBlock)DecorBlocks.OXIDIZED_COPPER_LANTERN.get());
        this.waxedlantern((LanternBlock)DecorBlocks.WAXED_OXIDIZED_COPPER_SOUL_LANTERN.get(), (LanternBlock)DecorBlocks.OXIDIZED_COPPER_SOUL_LANTERN.get());
        this.lantern((LanternBlock)DecorBlocks.NETHERITE_LANTERN.get());
        this.lantern((LanternBlock)DecorBlocks.NETHERITE_SOUL_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.GOLD_REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.COPPER_REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.EXPOSED_COPPER_REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.WEATHERED_COPPER_REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.OXIDIZED_COPPER_REDSTONE_LANTERN.get());
        this.waxedCopperRedstoneLantern((RedstoneLanternBlock)((Object)DecorBlocks.WAXED_COPPER_REDSTONE_LANTERN.get()), (LanternBlock)DecorBlocks.COPPER_REDSTONE_LANTERN.get());
        this.waxedCopperRedstoneLantern((RedstoneLanternBlock)((Object)DecorBlocks.WAXED_EXPOSED_COPPER_REDSTONE_LANTERN.get()), (LanternBlock)DecorBlocks.EXPOSED_COPPER_REDSTONE_LANTERN.get());
        this.waxedCopperRedstoneLantern((RedstoneLanternBlock)((Object)DecorBlocks.WAXED_WEATHERED_COPPER_REDSTONE_LANTERN.get()), (LanternBlock)DecorBlocks.WEATHERED_COPPER_REDSTONE_LANTERN.get());
        this.waxedCopperRedstoneLantern((RedstoneLanternBlock)((Object)DecorBlocks.WAXED_OXIDIZED_COPPER_REDSTONE_LANTERN.get()), (LanternBlock)DecorBlocks.OXIDIZED_COPPER_REDSTONE_LANTERN.get());
        this.redstoneLantern((LanternBlock)DecorBlocks.NETHERITE_REDSTONE_LANTERN.get());
        this.simpleTable((TableBlock)((Object)DecorBlocks.OAK_TABLE_PLANKS.get()), Blocks.f_50705_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.OAK_TABLE_LOGS.get()), Blocks.f_49999_, Blocks.f_49999_, Blocks.f_50010_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.OAK_TABLE_STRIPPED_LOGS.get()), Blocks.f_50010_, Blocks.f_50010_, Blocks.f_50010_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.OAK_TABLE_PLANKS_LOGS.get()), Blocks.f_50705_, Blocks.f_49999_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.OAK_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50705_, Blocks.f_50010_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.OAK_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50010_, Blocks.f_49999_, Blocks.f_50010_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_PLANKS.get()), Blocks.f_50745_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_LOGS.get()), Blocks.f_50004_, Blocks.f_50004_, Blocks.f_50009_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_STRIPPED_LOGS.get()), Blocks.f_50009_, Blocks.f_50009_, Blocks.f_50009_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_PLANKS_LOGS.get()), Blocks.f_50745_, Blocks.f_50004_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50745_, Blocks.f_50009_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.DARK_OAK_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50009_, Blocks.f_50004_, Blocks.f_50009_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.SPRUCE_TABLE_PLANKS.get()), Blocks.f_50741_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.SPRUCE_TABLE_LOGS.get()), Blocks.f_50000_, Blocks.f_50000_, Blocks.f_50005_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.SPRUCE_TABLE_STRIPPED_LOGS.get()), Blocks.f_50005_, Blocks.f_50005_, Blocks.f_50005_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.SPRUCE_TABLE_PLANKS_LOGS.get()), Blocks.f_50741_, Blocks.f_50000_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.SPRUCE_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50741_, Blocks.f_50005_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.SPRUCE_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50005_, Blocks.f_50000_, Blocks.f_50005_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.JUNGLE_TABLE_PLANKS.get()), Blocks.f_50743_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.JUNGLE_TABLE_LOGS.get()), Blocks.f_50002_, Blocks.f_50002_, Blocks.f_50007_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.JUNGLE_TABLE_STRIPPED_LOGS.get()), Blocks.f_50007_, Blocks.f_50007_, Blocks.f_50007_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.JUNGLE_TABLE_PLANKS_LOGS.get()), Blocks.f_50743_, Blocks.f_50002_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.JUNGLE_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50743_, Blocks.f_50007_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.JUNGLE_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50007_, Blocks.f_50002_, Blocks.f_50007_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.ACACIA_TABLE_PLANKS.get()), Blocks.f_50744_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.ACACIA_TABLE_LOGS.get()), Blocks.f_50003_, Blocks.f_50003_, Blocks.f_50008_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.ACACIA_TABLE_STRIPPED_LOGS.get()), Blocks.f_50008_, Blocks.f_50008_, Blocks.f_50008_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.ACACIA_TABLE_PLANKS_LOGS.get()), Blocks.f_50744_, Blocks.f_50003_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.ACACIA_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50744_, Blocks.f_50008_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.ACACIA_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50008_, Blocks.f_50003_, Blocks.f_50008_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.BIRCH_TABLE_PLANKS.get()), Blocks.f_50742_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.BIRCH_TABLE_LOGS.get()), Blocks.f_50001_, Blocks.f_50001_, Blocks.f_50006_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.BIRCH_TABLE_STRIPPED_LOGS.get()), Blocks.f_50006_, Blocks.f_50006_, Blocks.f_50006_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.BIRCH_TABLE_PLANKS_LOGS.get()), Blocks.f_50742_, Blocks.f_50001_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.BIRCH_TABLE_PLANKS_STRIPPED_LOGS.get()), Blocks.f_50742_, Blocks.f_50006_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.BIRCH_TABLE_STRIPPED_LOGS_LOGS.get()), Blocks.f_50006_, Blocks.f_50001_, Blocks.f_50006_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WARPED_TABLE_PLANKS.get()), Blocks.f_50656_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.WARPED_TABLE_STEMS.get()), Blocks.f_50686_, Blocks.f_50686_, Blocks.f_50687_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.WARPED_TABLE_STRIPPED_STEMS.get()), Blocks.f_50687_, Blocks.f_50687_, Blocks.f_50687_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.WARPED_TABLE_PLANKS_STEMS.get()), Blocks.f_50656_, Blocks.f_50686_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.WARPED_TABLE_PLANKS_STRIPPED_STEMS.get()), Blocks.f_50656_, Blocks.f_50687_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.WARPED_TABLE_STRIPPED_STEMS_STEMS.get()), Blocks.f_50687_, Blocks.f_50686_, Blocks.f_50687_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.CRIMSON_TABLE_PLANKS.get()), Blocks.f_50655_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.CRIMSON_TABLE_STEMS.get()), Blocks.f_50695_, Blocks.f_50695_, Blocks.f_50696_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.CRIMSON_TABLE_STRIPPED_STEMS.get()), Blocks.f_50696_, Blocks.f_50696_, Blocks.f_50696_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.CRIMSON_TABLE_PLANKS_STEMS.get()), Blocks.f_50655_, Blocks.f_50695_);
        this.twoBlockTable((TableBlock)((Object)DecorBlocks.CRIMSON_TABLE_PLANKS_STRIPPED_STEMS.get()), Blocks.f_50655_, Blocks.f_50696_);
        this.logTable((LogTableBlock)((Object)DecorBlocks.CRIMSON_TABLE_STRIPPED_STEMS_STEMS.get()), Blocks.f_50696_, Blocks.f_50695_, Blocks.f_50696_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DIORITE_TABLE.get()), Blocks.f_50228_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DIORITE_TABLE_POLISHED.get()), Blocks.f_50281_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.GRANITE_TABLE.get()), Blocks.f_50122_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.GRANITE_TABLE_POLISHED.get()), Blocks.f_50175_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.ANDESITE_TABLE.get()), Blocks.f_50334_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.ANDESITE_TABLE_POLISHED.get()), Blocks.f_50387_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.STONE_BRICKS_TABLE.get()), Blocks.f_50222_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.SMOOTH_STONE_TABLE.get()), Blocks.f_50470_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.QUARTZ_BRICK_TABLE.get()), Blocks.f_50714_);
        this.table((TableBlock)((Object)DecorBlocks.SMOOTH_QUARTZ_TABLE.get()), this.getTextureFromBlock(Blocks.f_50333_, "_bottom"), this.getTextureFromBlock(Blocks.f_50333_, "_bottom"), this.getTextureFromBlock(Blocks.f_50333_, "_bottom"));
        this.simpleTable((TableBlock)((Object)DecorBlocks.NETHER_BRICK_TABLE.get()), Blocks.f_50197_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.RED_NETHER_BRICK_TABLE.get()), Blocks.f_50452_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.POLISHED_BLACKSTONE_BRICKS_TABLE.get()), Blocks.f_50735_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.POLISHED_BLACKSTONE_TABLE.get()), Blocks.f_50734_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.BRICK_TABLE.get()), Blocks.f_50076_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.PURPUR_TABLE.get()), Blocks.f_50492_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.END_STONE_BRICKS_TABLE.get()), Blocks.f_50443_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.CUT_COPPER_TABLE.get()), Blocks.f_152510_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.EXPOSED_CUT_COPPER_TABLE.get()), Blocks.f_152509_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WEATHERED_CUT_COPPER_TABLE.get()), Blocks.f_152508_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.OXIDIZED_CUT_COPPER_TABLE.get()), Blocks.f_152507_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WAXED_CUT_COPPER_TABLE.get()), Blocks.f_152510_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WAXED_EXPOSED_CUT_COPPER_TABLE.get()), Blocks.f_152509_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WAXED_WEATHERED_CUT_COPPER_TABLE.get()), Blocks.f_152508_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.WAXED_OXIDIZED_CUT_COPPER_TABLE.get()), Blocks.f_152507_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.CUT_SANDSTONE_TABLE.get()), Blocks.f_50064_);
        this.table((TableBlock)((Object)DecorBlocks.SMOOTH_SANDSTONE_TABLE.get()), this.getTextureFromBlock(Blocks.f_50062_, "_top"), this.getTextureFromBlock(Blocks.f_50062_, "_top"), this.getTextureFromBlock(Blocks.f_50062_, "_top"));
        this.simpleTable((TableBlock)((Object)DecorBlocks.RED_CUT_SANDSTONE_TABLE.get()), Blocks.f_50396_);
        this.table((TableBlock)((Object)DecorBlocks.SMOOTH_RED_SANDSTONE_TABLE.get()), this.getTextureFromBlock(Blocks.f_50394_, "_top"), this.getTextureFromBlock(Blocks.f_50394_, "_top"), this.getTextureFromBlock(Blocks.f_50394_, "_top"));
        this.simpleTable((TableBlock)((Object)DecorBlocks.POLISHED_DEEPSLATE_TABLE.get()), Blocks.f_152555_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DEEPSLATE_BRICK_TABLE.get()), Blocks.f_152589_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DEEPSLATE_TILE_TABLE.get()), Blocks.f_152559_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.PRISMARINE_BRICK_TABLE.get()), Blocks.f_50378_);
        this.simpleTable((TableBlock)((Object)DecorBlocks.DARK_PRISMARINE_TABLE.get()), Blocks.f_50379_);
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.RED_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.ORANGE_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.YELLOW_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.LIME_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.GREEN_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.CYAN_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.BLUE_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.LIGHT_BLUE_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.PURPLE_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.MAGENTA_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.PINK_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.BROWN_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.BLACK_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.GRAY_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.LIGHT_GRAY_REDSTONE_LAMP.get());
        this.redstoneLamp((RedstoneLampBlock)DecorBlocks.WHITE_REDSTONE_LAMP.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.REDSTONE_CHAIN.get()), (ChainBlock)Blocks.f_50184_);
        this.chainBlock((ChainBlock)DecorBlocks.GOLD_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.GOLD_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.GOLD_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.NETHERITE_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.NETHERITE_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.NETHERITE_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.EXPOSED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.EXPOSED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.EXPOSED_COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.WEATHERED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.WEATHERED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.WEATHERED_COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.OXIDIZED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.OXIDIZED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.OXIDIZED_COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.WAXED_COPPER_CHAIN.get(), (Block)DecorBlocks.COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.WAXED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.WAXED_EXPOSED_COPPER_CHAIN.get(), (Block)DecorBlocks.EXPOSED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.WAXED_EXPOSED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.EXPOSED_COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.WAXED_WEATHERED_COPPER_CHAIN.get(), (Block)DecorBlocks.WEATHERED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.WAXED_WEATHERED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.WEATHERED_COPPER_CHAIN.get());
        this.chainBlock((ChainBlock)DecorBlocks.WAXED_OXIDIZED_COPPER_CHAIN.get(), (Block)DecorBlocks.OXIDIZED_COPPER_CHAIN.get());
        this.redstoneChainBlock((RedstoneChainBlock)((Object)DecorBlocks.WAXED_OXIDIZED_COPPER_REDSTONE_CHAIN.get()), (ChainBlock)DecorBlocks.OXIDIZED_COPPER_CHAIN.get());
    }

    public void chainBlock(ChainBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.modLoc("template_chain"))).texture("all", this.blockTexture((Block)block));
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> DecorBlockstates.lambda$chainBlock$0((ModelFile)model, arg_0), new Property[]{ChainBlock.f_51446_});
    }

    public void chainBlock(ChainBlock chain, Block textureBlock) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)chain), this.modLoc("template_chain"))).texture("all", this.blockTexture(textureBlock));
        this.getVariantBuilder((Block)chain).forAllStatesExcept(arg_0 -> DecorBlockstates.lambda$chainBlock$1((ModelFile)model, arg_0), new Property[]{ChainBlock.f_51446_});
    }

    public void redstoneChainBlock(RedstoneChainBlock block, ChainBlock nonRedstoneBlock) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.modLoc("template_redstone_chain"))).texture("chain", this.blockTexture((Block)nonRedstoneBlock));
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> DecorBlockstates.lambda$redstoneChainBlock$2((ModelFile)model, arg_0), new Property[]{ChainBlock.f_51446_, RedstoneChainBlock.POWER});
    }

    public void redstoneLamp(RedstoneLampBlock lamp) {
        this.redstoneLamp(lamp, this.getTextureFromBlock((Block)lamp, "_on"), this.getTextureFromBlock((Block)lamp));
    }

    public void redstoneLamp(RedstoneLampBlock lamp, ResourceLocation lit, ResourceLocation unlit) {
        ModelBuilder litModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)lamp) + "_lit", this.mcLoc("block/cube_all"))).texture("all", lit);
        ModelBuilder unlitModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)lamp), this.mcLoc("block/cube_all"))).texture("all", unlit);
        this.redstoneLamp(lamp, (ModelFile)litModel, (ModelFile)unlitModel);
    }

    public void redstoneLamp(RedstoneLampBlock lamp, ModelFile litModel, ModelFile unlitModel) {
        this.getVariantBuilder((Block)lamp).forAllStatesExcept(state -> {
            Boolean lit = (Boolean)state.m_61143_((Property)RedstoneLampBlock.f_55654_);
            return ConfiguredModel.builder().modelFile(lit != false ? litModel : unlitModel).build();
        }, new Property[]{LanternBlock.f_153460_});
    }

    public void simpleTable(TableBlock table, Block block) {
        this.table(table, this.getTextureFromBlock(block), this.getTextureFromBlock(block), this.getTextureFromBlock(block));
    }

    public void simpleTwoBlockTable(TableBlock table, Block top, Block post) {
        this.table(table, this.getTextureFromBlock(top), this.getTextureFromBlock(post), this.getTextureFromBlock(post));
    }

    public void twoBlockTable(TableBlock table, Block top, Block post) {
        this.table(table, this.getTextureFromBlock(top), this.getTextureFromBlock(post), this.getTextureFromBlock(post, "_top"));
    }

    public void logTable(LogTableBlock table, Block top, Block post, Block stripped) {
        this.logTable(table, this.getTextureFromBlock(top), this.getTextureFromBlock(post), this.getTextureFromBlock(post, "_top"), this.getTextureFromBlock(top, "_top"), this.getTextureFromBlock(stripped));
    }

    public void logTable(LogTableBlock table, ResourceLocation top, ResourceLocation post_side, ResourceLocation post_bottom, ResourceLocation top_end, ResourceLocation top_underside) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)table), this.modLoc("block/log_table"))).texture("top", top)).texture("post_side", post_side)).texture("post_bottom", post_bottom)).texture("top_end", top_end)).texture("top_underside", top_underside);
        this.logTable(table, (ModelFile)model);
    }

    public void logTable(LogTableBlock table, ModelFile model) {
        this.getVariantBuilder(table).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HalfBlock.FACING);
            return ConfiguredModel.builder().modelFile(model).rotationY((int)facing.m_122424_().m_122435_()).build();
        }, new Property[]{LanternBlock.f_153460_});
    }

    public void table(TableBlock table, ResourceLocation top, ResourceLocation post_side, ResourceLocation post_bottom) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)table), this.modLoc("block/table"))).texture("top", top)).texture("post_side", post_side)).texture("post_bottom", post_bottom);
        this.table(table, (ModelFile)model);
    }

    public void table(TableBlock table, ModelFile model) {
        this.getVariantBuilder(table).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void waxedlantern(LanternBlock waxed, LanternBlock nonWaxedToCopy) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed), this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed) + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy));
        this.lantern(waxed, (ModelFile)model, (ModelFile)hangingModel);
    }

    public void waxedCopperRedstoneLantern(RedstoneLanternBlock waxed, LanternBlock nonWaxedToCopy) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed), this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed) + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy));
        ModelBuilder litModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed) + "_on", this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy, "_on"));
        ModelBuilder litHangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)waxed) + "_hanging_on", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)nonWaxedToCopy, "_on"));
        this.redstoneLantern(waxed, (ModelFile)model, (ModelFile)hangingModel, (ModelFile)litModel, (ModelFile)litHangingModel);
    }

    public void redstoneLantern(LanternBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        ModelBuilder litModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_on", this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block, "_on"));
        ModelBuilder litHangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_hanging_on", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block, "_on"));
        this.redstoneLantern(block, (ModelFile)model, (ModelFile)hangingModel, (ModelFile)litModel, (ModelFile)litHangingModel);
    }

    public void redstoneLantern(LanternBlock block, ModelFile model, ModelFile hangingModel, ModelFile litModel, ModelFile litHangingModel) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Boolean hanging = (Boolean)state.m_61143_((Property)LanternBlock.f_153459_);
            Boolean lit = (Boolean)state.m_61143_((Property)RedstoneLanternBlock.LIT);
            return ConfiguredModel.builder().modelFile(hanging.booleanValue() ? (lit.booleanValue() ? litHangingModel : hangingModel) : (lit != false ? litModel : model)).build();
        }, new Property[]{LanternBlock.f_153460_});
    }

    public void copperLantern(CopperLanternBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        this.copperLantern(block, (ModelFile)model, (ModelFile)hangingModel);
    }

    public void copperLantern(CopperLanternBlock block, ModelFile model, ModelFile hangingModel) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Boolean hanging = (Boolean)state.m_61143_((Property)LanternBlock.f_153459_);
            return ConfiguredModel.builder().modelFile(hanging != false ? hangingModel : model).build();
        }, new Property[]{LanternBlock.f_153460_, CopperLanternBlock.LIT});
    }

    public void lantern(LanternBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.mcLoc("block/template_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_hanging", this.mcLoc("block/template_hanging_lantern"))).texture("lantern", this.getTextureFromBlock((Block)block));
        this.lantern(block, (ModelFile)model, (ModelFile)hangingModel);
    }

    public void lantern(LanternBlock block, ModelFile model, ModelFile hangingModel) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Boolean hanging = (Boolean)state.m_61143_((Property)LanternBlock.f_153459_);
            return ConfiguredModel.builder().modelFile(hanging != false ? hangingModel : model).build();
        }, new Property[]{LanternBlock.f_153460_});
    }

    private String name(ItemLike block) {
        return block.m_5456_().getRegistryName().m_135815_();
    }

    private String namespace(ItemLike block) {
        return block.m_5456_().getRegistryName().m_135827_();
    }

    public void halfLogBench(HalfBlock block, Block log, Block strippedLog) {
        this.halfLogBench(block, this.getTextureFromBlock(log), this.getTextureFromBlock(strippedLog));
    }

    public void halfLogBench(HalfBlock block, ResourceLocation log, ResourceLocation strippedLog) {
        ModelBuilder bench = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.modLoc("block/half_bench"))).texture("side", log)).texture("top", strippedLog)).texture("end", strippedLog + "_top")).texture("bottom", log);
        this.halfLogBench(block, (ModelFile)bench);
    }

    public void halfLogBench(HalfBlock block, ModelFile model) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HalfBlock.FACING);
            return ConfiguredModel.builder().modelFile(model).rotationY((int)facing.m_122424_().m_122435_()).build();
        });
    }

    public void logBench(StairBlock block, Block log, Block strippedLog) {
        ResourceLocation diagonalTex = new ResourceLocation(block.getRegistryName().m_135827_(), "block/diagonal_" + this.name((ItemLike)log));
        ResourceLocation strippedDiagnoalTex = new ResourceLocation(block.getRegistryName().m_135827_(), "block/stripped_diagonal_" + this.name((ItemLike)log));
        this.logBench(block, this.getTextureFromBlock(log), this.getTextureFromBlock(strippedLog), diagonalTex, strippedDiagnoalTex);
    }

    public void logBench(StairBlock block, ResourceLocation log, ResourceLocation strippedLog, ResourceLocation diagonal, ResourceLocation strippedDiagonal) {
        ModelBuilder bench = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block), this.modLoc("block/log_bench"))).texture("side", log)).texture("inside", strippedLog)).texture("end", strippedLog + "_top");
        ModelBuilder benchInner = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_inner", this.modLoc("block/log_bench_inner"))).texture("side", log)).texture("inside", strippedLog)).texture("diagonal", strippedDiagonal)).texture("end", strippedLog + "_top")).texture("top", diagonal);
        ModelBuilder benchOuter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((ItemLike)block) + "_outer", this.modLoc("block/log_bench_outer"))).texture("side", log)).texture("diagonal", strippedDiagonal)).texture("end", strippedLog + "_top")).texture("top", diagonal);
        this.logBench(block, (ModelFile)bench, (ModelFile)benchInner, (ModelFile)benchOuter);
    }

    public void logBench(StairBlock block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = false;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(uvlock).build();
        }, new Property[]{StairBlock.f_56844_});
    }

    public ResourceLocation getTextureFromBlock(Block block) {
        return new ResourceLocation(block.getRegistryName().m_135827_(), "block/" + this.name((ItemLike)block));
    }

    public ResourceLocation getTextureFromBlock(String prefix, Block block) {
        return new ResourceLocation(block.getRegistryName().m_135827_(), "block/" + prefix + this.name((ItemLike)block));
    }

    public ResourceLocation getTextureFromBlock(Block block, String suffix) {
        return new ResourceLocation(block.getRegistryName().m_135827_(), "block/" + this.name((ItemLike)block) + suffix);
    }

    public void slabStoolPlanksBlock(SlabBlock block, String planks) {
        this.slabStoolBlock(block, this.modLoc("block/" + planks + "_slab_stool_side"), this.modLoc("block/" + planks + "_slab_stool_double"), this.mcLoc("block/" + planks + "_planks"));
    }

    public void slabStoolPlanksBlock(SlabBlock block, Block planks) {
        this.slabStoolBlock(block, this.getTextureFromBlock(planks), this.getTextureFromBlock(planks), this.getTextureFromBlock(planks));
    }

    public void slabStoolLogBlock(SlabBlock block, Block log) {
        this.slabStoolBlock(block, this.getTextureFromBlock(log), this.getTextureFromBlock(log), new ResourceLocation(log.getRegistryName().m_135827_(), "block/" + this.name((ItemLike)log) + "_top"));
    }

    public void slabStoolBlock(SlabBlock block, ResourceLocation plankSide, ResourceLocation doublePlankSide, ResourceLocation bottom) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            BlockModelBuilder model;
            DyeColor color = (DyeColor)state.m_61143_(SlabStoolBlock.COLOR);
            SlabType slabType = (SlabType)state.m_61143_((Property)SlabStoolBlock.f_56353_);
            BlockModelBuilder neededModel = model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("white_" + this.name((ItemLike)block) + "_top", this.modLoc("block/slab_stool_top"))).texture("wool_side", this.modLoc("block/white_slab_stool_side"))).texture("plank_side", plankSide)).texture("bottom", bottom)).texture("top", this.modLoc("block/white_slab_stool_top"));
            for (DyeColor dye : DyeColor.values()) {
                if (slabType == SlabType.TOP) {
                    model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(dye.m_41065_() + "_" + this.name((ItemLike)block) + "_top", this.modLoc("block/slab_stool_top"))).texture("wool_side", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_side"))).texture("plank_side", plankSide)).texture("bottom", bottom)).texture("top", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_top"));
                    neededModel = dye == color ? model : neededModel;
                    continue;
                }
                if (slabType == SlabType.DOUBLE) {
                    model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(dye.m_41065_() + "_" + this.name((ItemLike)block) + "_double", this.modLoc("block/slab_stool_double"))).texture("wool_side", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_side"))).texture("plank_side", doublePlankSide)).texture("bottom", bottom)).texture("top", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_top"));
                    neededModel = dye == color ? model : neededModel;
                    continue;
                }
                model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(dye.m_41065_() + "_" + this.name((ItemLike)block), this.modLoc("block/slab_stool"))).texture("wool_side", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_side"))).texture("plank_side", plankSide)).texture("bottom", bottom)).texture("top", new ResourceLocation(this.namespace((ItemLike)block), "block/" + dye.m_41065_() + "_slab_stool_top"));
                neededModel = dye == color ? model : neededModel;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)neededModel).build();
        }, new Property[]{SlabStoolBlock.f_56354_});
    }

    private static /* synthetic */ ConfiguredModel[] lambda$redstoneChainBlock$2(ModelFile model, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)ChainBlock.f_55923_);
        int xRot = axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0;
        int yRot = axis == Direction.Axis.X ? 90 : 0;
        return ConfiguredModel.builder().modelFile(model).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chainBlock$1(ModelFile model, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)ChainBlock.f_55923_);
        int xRot = axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0;
        int yRot = axis == Direction.Axis.X ? 90 : 0;
        return ConfiguredModel.builder().modelFile(model).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chainBlock$0(ModelFile model, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)ChainBlock.f_55923_);
        int xRot = axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0;
        int yRot = axis == Direction.Axis.X ? 90 : 0;
        return ConfiguredModel.builder().modelFile(model).rotationX(xRot).rotationY(yRot).build();
    }
}

