/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.teampotato.ruok.gui.modern.option.ModernOption;
import team.teampotato.ruok.util.ColorUtil;

@OnlyIn(value=Dist.CLIENT)
public class CyclingButtonWidget<T>
extends AbstractButton {
    public static final BooleanSupplier HAS_ALT_DOWN = Screen::m_96639_;
    private static final List<Boolean> BOOLEAN_VALUES = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private int index;
    private T value;
    private final Values<T> values;
    private final Function<T, Component> valueToText;
    private final Function<CyclingButtonWidget<T>, MutableComponent> narrationMessageFactory;
    private final UpdateCallback<T> callback;
    private final boolean optionTextOmitted;
    private final ModernOption.TooltipFactory<T> tooltipFactory;
    private double buttonX;
    private final double animationSpeed = 0.15;

    CyclingButtonWidget(int x, int y, int width, int height, Component message, int index, T value, Values<T> values, Function<T, Component> valueToText, Function<CyclingButtonWidget<T>, MutableComponent> narrationMessageFactory, UpdateCallback<T> callback, ModernOption.TooltipFactory<T> tooltipFactory, boolean optionTextOmitted) {
        super(x, y, width, height, message);
        this.buttonX = this.f_93618_ + this.m_252754_();
        this.animationSpeed = 0.15;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueToText = valueToText;
        this.narrationMessageFactory = narrationMessageFactory;
        this.callback = callback;
        this.optionTextOmitted = optionTextOmitted;
        this.tooltipFactory = tooltipFactory;
        this.refreshTooltip();
    }

    private void refreshTooltip() {
        this.m_257544_(this.tooltipFactory.apply(this.value));
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.cycle(-1);
        } else {
            this.cycle(1);
        }
    }

    public int getValueInt() {
        T object = this.getValue(1);
        if (object instanceof Boolean) {
            Boolean e = (Boolean)object;
            return e != false ? 1 : 0;
        }
        if (object instanceof Enum) {
            Enum e = (Enum)object;
            return e.ordinal();
        }
        return -1;
    }

    public int getValueMaxInt() {
        Enum e;
        Enum[] values;
        T object = this.getValue(1);
        if (object instanceof Enum && (values = (Enum[])(e = (Enum)object).getDeclaringClass().getEnumConstants()) != null && values.length > 0) {
            return values[values.length - 1].ordinal();
        }
        if (object instanceof Boolean) {
            return 1;
        }
        return -1;
    }

    public MutableComponent getValueToText() {
        T object = this.getValue(1);
        Component text = this.valueToText.apply(object);
        return Component.m_237119_().m_7220_(text);
    }

    public boolean isEnum() {
        return this.value instanceof Enum;
    }

    protected void m_87963_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        context.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int alphaValue = Mth.m_14167_((float)(this.f_93625_ * 255.0f));
        int color = this.m_198029_() ? ColorUtil.getAUIColor(-804253680, 0.8) : ColorUtil.getAUIColor(-804253680, 0.5);
        context.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
        if (!this.isEnum()) {
            this.renderBooleanButton(context);
        } else {
            this.renderButtonSetting(context, mouseX, mouseY, delta);
        }
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        this.m_280139_(context, minecraftClient.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    public void m_280139_(GuiGraphics context, Font textRenderer, int color) {
        this.m_280372_(context, textRenderer, 2, color);
    }

    public void m_280372_(GuiGraphics context, Font textRenderer, int xMargin, int color) {
        int left = this.m_252754_() + xMargin + 5;
        int right = this.m_252754_() + this.m_5711_() - xMargin;
        CyclingButtonWidget.drawScrollableText(context, textRenderer, this.m_6035_(), left, this.m_252907_(), right, this.m_252907_() + this.m_93694_(), color);
    }

    public static void drawScrollableText(GuiGraphics context, Font textRenderer, Component text, int left, int top, int right, int bottom, int color) {
        int textWidth = textRenderer.m_92852_((FormattedText)text);
        int textHeight = 9;
        int centerY = (top + bottom - textHeight) / 2 + 1;
        int maxWidth = right - left;
        if (textWidth > maxWidth) {
            int overflowWidth = textWidth - maxWidth;
            double time = (double)Util.m_137550_() / 1000.0;
            double scrollSpeed = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * time / scrollSpeed)) / 2.0 + 0.5;
            double scrollX = Mth.m_14139_((double)scrollFactor, (double)0.0, (double)overflowWidth);
            context.m_280588_(left, top, right, bottom);
            context.m_280430_(textRenderer, text, left - (int)scrollX, centerY, color);
            context.m_280618_();
        } else {
            context.m_280430_(textRenderer, text, left, centerY, color);
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void renderButtonSetting(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.m_91087_();
        int endX = this.f_93618_ + this.m_252754_();
        int textX = endX - 33;
        int y = this.m_252907_();
        int maxLevel = this.getValueMaxInt() + 1;
        int spacing = 8;
        int totalWidth = (maxLevel - 1) * spacing;
        int lineXStart = endX - totalWidth / 2 - 30;
        int textColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        MutableComponent text = this.getValueToText();
        context.m_280614_(mc.f_91062_, (Component)text, textX, y + 3, textColor, false);
        int level = this.getValueInt();
        for (int i = 0; i < maxLevel; ++i) {
            int color = i == level ? -7798904 : -7829368;
            int lineX = lineXStart + i * spacing;
            int lineY = y + this.f_93619_ / 2 + 2 + 3;
            context.m_280509_(lineX, lineY, lineX + 6, lineY + 2, color);
        }
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public int m_93694_() {
        return super.m_93694_();
    }

    protected void renderBooleanButton(@NotNull GuiGraphics context) {
        int endX = this.f_93618_ + this.m_252754_();
        int fillXStart = endX - 15;
        int fillXEnd = endX - 5;
        int z = 7;
        boolean buttonOn = this.getValueInt() == 0;
        int targetButtonX = buttonOn ? fillXStart + 3 : fillXEnd - 17;
        this.buttonX = this.lerp(this.buttonX, targetButtonX, 0.15);
        int startColor = -7829368;
        int endColor = -7798904;
        int bgColor = this.lerpColor(startColor, endColor, buttonOn ? 1.0f : 0.0f);
        context.m_280509_(fillXStart - 8, this.m_252907_() + this.f_93619_ / 2 + 1, fillXEnd, this.m_252907_() + this.f_93619_ / 2 - 1, bgColor);
        context.m_280509_((int)this.buttonX - 1, this.m_252907_() + z, (int)this.buttonX + 8, this.m_252907_() + this.f_93619_ - z, -1);
    }

    private double lerp(double from, double to, double progress) {
        return from + (to - from) * progress;
    }

    private int lerpColor(int startColor, int endColor, float progress) {
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int newA = (int)this.lerp(startA, endA, progress);
        int newR = (int)this.lerp(startR, endR, progress);
        int newG = (int)this.lerp(startG, endG, progress);
        int newB = (int)this.lerp(startB, endB, progress);
        return newA << 24 | newR << 16 | newG << 8 | newB;
    }

    private void cycle(int amount) {
        List<T> list = this.values.getCurrent();
        this.index = Mth.m_14100_((int)(this.index + amount), (int)list.size());
        T object = list.get(this.index);
        this.internalSetValue(object);
        this.callback.onValueChange(this, object);
    }

    private T getValue(int offset) {
        List<T> list = this.values.getCurrent();
        return list.get(Mth.m_14100_((int)(this.index + offset), (int)list.size()));
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.cycle(-1);
        } else if (amount < 0.0) {
            this.cycle(1);
        }
        return true;
    }

    public void setValue(T value) {
        List<T> list = this.values.getCurrent();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.internalSetValue(value);
    }

    private void internalSetValue(T value) {
        this.value = value;
        this.refreshTooltip();
    }

    public T getValue() {
        return this.value;
    }

    protected MutableComponent m_5646_() {
        return this.narrationMessageFactory.apply(this);
    }

    public void m_168797_(NarrationElementOutput builder) {
        builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            T object = this.getValue(1);
            Component text = this.valueToText.apply(object);
            if (this.m_93696_()) {
                builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{text}));
            } else {
                builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237110_((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{text}));
            }
        }
    }

    public static <T> Builder<T> builder(Function<T, Component> valueToText) {
        return new Builder<T>(valueToText);
    }

    public static Builder<Boolean> onOffBuilder(Component on, Component off) {
        return new Builder<Boolean>(value -> value != false ? on : off).values((Collection<Boolean>)BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(value -> value != false ? CommonComponents.f_130653_ : CommonComponents.f_130654_).values((Collection<Boolean>)BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder(boolean initialValue) {
        return CyclingButtonWidget.onOffBuilder().initially(initialValue);
    }

    public boolean isOptionTextOmitted() {
        return this.optionTextOmitted;
    }

    private MutableComponent getMessageMutable() {
        return Component.m_237119_().m_7220_(this.m_6035_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Values<T> {
        public List<T> getCurrent();

        public List<T> getDefaults();

        public static <T> Values<T> of(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new Values<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getCurrent() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }

        public static <T> Values<T> of(final BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            ImmutableList list = ImmutableList.copyOf(defaults);
            ImmutableList list2 = ImmutableList.copyOf(alternatives);
            return new Values<T>(){
                final /* synthetic */ List val$list2;
                final /* synthetic */ List val$list;
                {
                    this.val$list2 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getCurrent() {
                    return alternativeToggle.getAsBoolean() ? this.val$list2 : this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface UpdateCallback<T> {
        public void onValueChange(CyclingButtonWidget<T> var1, T var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T value;
        private final Function<T, Component> valueToText;
        private ModernOption.TooltipFactory<T> tooltipFactory = value -> null;
        private Function<CyclingButtonWidget<T>, MutableComponent> narrationMessageFactory = CyclingButtonWidget::getMessageMutable;
        private Values<T> values = Values.of(ImmutableList.of());
        private boolean optionTextOmitted;

        public Builder(Function<T, Component> valueToText) {
            this.valueToText = valueToText;
        }

        public Builder<T> values(Collection<T> values) {
            return this.values(Values.of(values));
        }

        @SafeVarargs
        public final Builder<T> values(T ... values) {
            return this.values((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> values(List<T> defaults, List<T> alternatives) {
            return this.values(Values.of(HAS_ALT_DOWN, defaults, alternatives));
        }

        public Builder<T> values(BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            return this.values(Values.of(alternativeToggle, defaults, alternatives));
        }

        public Builder<T> values(Values<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> tooltip(ModernOption.TooltipFactory<T> tooltipFactory) {
            this.tooltipFactory = tooltipFactory;
            return this;
        }

        public Builder<T> initially(T value) {
            this.value = value;
            int i = this.values.getDefaults().indexOf(value);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> narration(Function<CyclingButtonWidget<T>, MutableComponent> narrationMessageFactory) {
            this.narrationMessageFactory = narrationMessageFactory;
            return this;
        }

        public Builder<T> omitKeyText() {
            this.optionTextOmitted = true;
            return this;
        }

        public CyclingButtonWidget<T> build(int x, int y, int width, int height, Component optionText) {
            return this.build(x, y, width, height, optionText, (button, value) -> {});
        }

        public CyclingButtonWidget<T> build(int x, int y, int width, int height, Component optionText, UpdateCallback<T> callback) {
            List<T> list = this.values.getDefaults();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.value != null ? this.value : list.get(this.initialIndex);
            Component text = this.valueToText.apply(object);
            Component text2 = this.optionTextOmitted ? text : CommonComponents.m_178393_((Component)optionText, (Component)text);
            return new CyclingButtonWidget<T>(x, y, width, height, optionText, this.initialIndex, object, this.values, this.valueToText, this.narrationMessageFactory, callback, this.tooltipFactory, this.optionTextOmitted);
        }
    }
}

