/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.mixin.minecraft;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.WindowEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.GameSystemMonitor;
import team.teampotato.ruok.util.clazz.StartTime;
import team.teampotato.ruok.util.hook.HookDispatcher;

@Mixin(value={Minecraft.class}, priority=1100)
public abstract class MinecraftClientMixin
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler {
    @Shadow
    @Final
    public Options f_91066_;

    public MinecraftClientMixin(String string) {
        super(string);
    }

    @Inject(method={"onInitFinished"}, at={@At(value="HEAD")})
    private void onInitHead(CallbackInfo ci) {
        StartTime.start();
    }

    @Inject(method={"onInitFinished"}, at={@At(value="RETURN")})
    private void onInitReturn(CallbackInfo ci) {
        GameSystemMonitor.setInitState(true);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        HookDispatcher.fire(HookDispatcher.HookType.TICK);
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Recorder;isActive()Z", ordinal=0)})
    private boolean getGPU(MetricsRecorder instance, Operation<Boolean> original) {
        if (RuOK.get().GuiGPU) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"stop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;disconnect()V")})
    public void onStop(CallbackInfo ci) {
        HookDispatcher.fire(HookDispatcher.HookType.STOP);
    }
}

