/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.ToastUtil;

public class GameSystemMonitor {
    private static List<String> previousSoundDevices = List.of();
    private static boolean initState = false;
    private static int delay = 0;

    public static void setInitState(boolean initState) {
        GameSystemMonitor.initState = initState;
    }

    public static boolean isInitState() {
        return initState;
    }

    public static void run(Minecraft mc) {
        if (RuOK.get().SoundDevicesMonitor && ++delay > 8) {
            GameSystemMonitor.runSoundDevicesMonitor(mc.m_91106_());
            delay = 0;
        }
    }

    private static void runSoundDevicesMonitor(@NotNull SoundManager sm) {
        List currentSoundDevices = sm.m_194525_();
        if (!currentSoundDevices.equals(previousSoundDevices)) {
            String devices = (String)currentSoundDevices.get(0);
            if (devices.startsWith("OpenAL Soft on ")) {
                devices = devices.substring("OpenAL Soft on ".length());
            }
            MutableComponent info = Component.m_237110_((String)"ruok.options.toast.sounddevice.device", (Object[])new Object[]{devices});
            if (devices.isEmpty()) {
                info = Component.m_237115_((String)"ruok.options.toast.sounddevice.default");
            }
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.toast.sounddevice.changed"), (Component)info);
            previousSoundDevices = currentSoundDevices;
        }
    }
}

