/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.clazz;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.transformer.Config;
import team.teampotato.ruok.RuOKMod;
import team.teampotato.ruok.util.HardwareInfoUtil;
import team.teampotato.ruok.util.ToastUtil;

public class ClassManager {
    private static final String SECTION_SEPARATOR = "=====================================";
    private static final String SUB_SECTION_SEPARATOR = "-------------------------------------";
    private static final String PLUGIN_INFO_SEPARATOR = ">>>>>-----[Plugin Info]-----<<<<<";
    private static final double CTR_VERSION = 1.2;

    public static void saveToFile() {
        String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String baseDir = "logs/class_tracker_" + timestamp;
        try {
            Files.createDirectories(Paths.get(baseDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            RuOKMod.LOGGER.error("Failed to create log directory: " + baseDir, (Throwable)e);
            return;
        }
        String next = System.lineSeparator();
        StringBuilder systemInfo = new StringBuilder();
        systemInfo.append(ClassManager.colorize("[System Info]", "35")).append(next);
        systemInfo.append(String.format("RuOK ClassTrack Version: %s", 1.2)).append(next);
        systemInfo.append(String.format("Java Version: %s", Runtime.version())).append(next);
        systemInfo.append(String.format("Minecraft Version: %s", Minecraft.m_91087_().m_91388_())).append(next);
        systemInfo.append(String.format("Particle Count: %s", Minecraft.m_91087_().f_91061_.m_107403_())).append(next);
        ClassManager.saveLogToFile(baseDir, "system_info.log", systemInfo.toString());
        StringBuilder classLoadingInfo = new StringBuilder();
        ClassLoadingMXBean clb = ManagementFactory.getClassLoadingMXBean();
        classLoadingInfo.append(ClassManager.colorize("[Class Loading Stats]", "35")).append(next);
        classLoadingInfo.append(String.format("Total Loaded Classes: %d", clb.getTotalLoadedClassCount())).append(next);
        classLoadingInfo.append(String.format("Currently Loaded Classes: %d", clb.getLoadedClassCount())).append(next);
        classLoadingInfo.append(String.format("Unloaded Classes: %d", clb.getUnloadedClassCount())).append(next);
        ClassManager.saveLogToFile(baseDir, "class_loading.log", classLoadingInfo.toString());
        StringBuilder threadInfo = new StringBuilder();
        ClassManager.getThreadString(threadInfo, next);
        ClassManager.saveLogToFile(baseDir, "threads.log", threadInfo.toString());
        StringBuilder hardwareInfo = new StringBuilder();
        ClassManager.getHardwareString(hardwareInfo, next);
        ClassManager.saveLogToFile(baseDir, "hardware_info.log", hardwareInfo.toString());
        StringBuilder mixinInfo = new StringBuilder();
        ClassManager.getMixin(mixinInfo, next);
        ClassManager.saveLogToFile(baseDir, "mixin_info.log", mixinInfo.toString());
        StringBuilder memoryInfo = new StringBuilder();
        ClassManager.getObject(memoryInfo, next);
        ClassManager.saveLogToFile(baseDir, "memory_info.log", memoryInfo.toString());
        ToastUtil.send((Component)Component.m_237115_((String)"ruok.setting.debug.tracker.save.file.title"), (Component)Component.m_237110_((String)"ruok.setting.debug.tracker.save.file.info", (Object[])new Object[]{baseDir}));
    }

    private static void saveLogToFile(String dir, String filename, String content) {
        try {
            Files.write(Paths.get(dir, filename), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            RuOKMod.LOGGER.error("Failed to write log: {}", (Object)filename, (Object)e);
        }
    }

    private static void getObject(StringBuilder logContent, String next) {
        logContent.append(ClassManager.colorize("[MemoryMXBean Information]", "35")).append(next);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        MemoryUsage heapMemory = memoryMXBean.getHeapMemoryUsage();
        logContent.append("Heap Memory Used: ").append(heapMemory.getUsed() / 0x100000L).append(" MB / ").append(heapMemory.getMax() / 0x100000L).append(" MB").append(next);
        for (MemoryPoolMXBean pool : memoryPools) {
            MemoryUsage usage = pool.getUsage();
            logContent.append("Memory Pool [").append(pool.getName()).append("]: ").append(usage.getUsed() / 0x100000L).append(" MB / ").append(usage.getMax() / 0x100000L).append(" MB").append(next);
        }
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            logContent.append("GC [").append(gcBean.getName()).append("] Count: ").append(gcBean.getCollectionCount()).append(next);
        }
        logContent.append(SECTION_SEPARATOR).append(next);
    }

    private static void getThreadString(StringBuilder logContent, String next) {
        logContent.append(ClassManager.colorize("[Thread Information]", "35")).append(next);
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        map.forEach((thread, stackTraceElements) -> {
            logContent.append(String.format("  Thread: %s (ID: %d)", thread.getName(), thread.getId())).append(next);
            logContent.append(String.format("  State: %s", new Object[]{thread.getState()})).append(next);
            logContent.append(String.format("  Thread Group: %s", thread.getThreadGroup().getName())).append(next);
            logContent.append("  -------- Stack Trace --------").append(next);
            for (StackTraceElement st : stackTraceElements) {
                logContent.append(String.format("    File: %s", st.getFileName())).append(next);
                logContent.append(String.format("    Class: %s", st.getClassName())).append(next);
                logContent.append(String.format("    Method: %s", st.getMethodName())).append(next);
                logContent.append(String.format("    ClassLoader: %s", st.getClassLoaderName())).append(next);
                logContent.append(String.format("    Module: %s", st.getModuleName())).append(next);
                logContent.append(String.format("    Module Version: %s", st.getModuleVersion())).append(next);
                logContent.append("    ------------------------------").append(next);
            }
            logContent.append(SECTION_SEPARATOR).append(next);
        });
    }

    private static void getHardwareString(StringBuilder logContent, String next) {
        logContent.append(ClassManager.colorize("[Hardware Information]", "35")).append(next);
        logContent.append("  ").append(HardwareInfoUtil.getCpuInfo()).append(next);
        logContent.append("  ").append(HardwareInfoUtil.getMemoryInfo()).append(next);
        logContent.append("  ").append(HardwareInfoUtil.getDiskInfo()).append(next);
        logContent.append("  ").append(HardwareInfoUtil.getOsInfo()).append(next);
        logContent.append(SECTION_SEPARATOR).append(next);
    }

    public static void getMixin(StringBuilder logContent, String next) {
        logContent.append(ClassManager.colorize("[MixinClass Details]", "35")).append(next);
        HashMap targetToMixins = new HashMap();
        ClassManager.getMixinConfigs().forEach((string, config) -> {
            logContent.append(String.format("  [Configs]: %s", config.getConfig().getName())).append(next);
            logContent.append(String.format("  [Priority]: %d", config.getConfig().getPriority())).append(next);
            logContent.append(String.format("  [Package]: %s", config.getConfig().getMixinPackage())).append(next);
            logContent.append(String.format("  [Environment Version]: %s", config.getConfig().getEnvironment().getVersion())).append(next);
            logContent.append("  [Targets]").append(next);
            for (String target : config.getConfig().getTargets()) {
                logContent.append(String.format("      - %s", target)).append(next);
                targetToMixins.computeIfAbsent(target, k -> new ArrayList()).add(config.getConfig().getName());
            }
            if (config.getConfig().getPlugin() != null) {
                logContent.append(PLUGIN_INFO_SEPARATOR).append(next);
                logContent.append(String.format("    [RefMapperConfig]: %s", config.getConfig().getPlugin().getRefMapperConfig())).append(next);
                if (config.getConfig().getPlugin().getMixins() != null) {
                    logContent.append("    [Mixins]").append(next);
                    config.getConfig().getPlugin().getMixins().forEach(e -> logContent.append(String.format("        - %s", e)).append(next));
                }
                logContent.append(PLUGIN_INFO_SEPARATOR).append(next);
            }
            logContent.append(SUB_SECTION_SEPARATOR).append(next);
        });
        logContent.append(SECTION_SEPARATOR).append(next);
        logContent.append(ClassManager.colorize("[Mixin Target Summary]", "36")).append(next);
        targetToMixins.entrySet().stream().sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).forEach(entry -> {
            String target = (String)entry.getKey();
            List mixins = (List)entry.getValue();
            logContent.append(String.format(" - Target (Mixins: %d): %s", mixins.size(), target)).append(next);
            for (String mixin : mixins) {
                logContent.append(String.format("   - (%s)", mixin)).append(next);
            }
        });
        logContent.append(SECTION_SEPARATOR).append(next);
    }

    private static Map<String, Config> getMixinConfigs() {
        Field allConfigsField;
        Class<Config> configClass = Config.class;
        try {
            allConfigsField = configClass.getDeclaredField("allConfigs");
        }
        catch (NoSuchFieldException e) {
            RuOKMod.LOGGER.error("Field 'allConfigs' not found in class Config.", (Throwable)e);
            throw new RuntimeException("Field 'allConfigs' not found in class Config.", e);
        }
        allConfigsField.setAccessible(true);
        try {
            Map allConfigs = (Map)allConfigsField.get(null);
            return allConfigs;
        }
        catch (IllegalAccessException e) {
            RuOKMod.LOGGER.error("Illegal access to field 'allConfigs'.", (Throwable)e);
            throw new RuntimeException("Illegal access to field 'allConfigs'.", e);
        }
    }

    private static String colorize(String text, String colorCode) {
        if (System.console() != null) {
            return "\u001b[" + colorCode + "m" + text + "\u001b[0m";
        }
        return text;
    }
}

