/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.entity.EntityCullRender;
import team.teampotato.ruok.util.hook.HookDispatcher;
import team.teampotato.ruok.util.render.CameraUtil;

public class EntityUtils {
    private static volatile List<Entity> entities = Collections.emptyList();

    public static void refViewEntity() {
        entities = EntityUtils.getEntitiesInView(RuOK.get().EntityDistance, RuOK.get().MaxEntityEntities);
    }

    @NotNull
    public static @UnmodifiableView List<Entity> getVisibleEntities() {
        return entities;
    }

    public static List<Entity> getEntitiesInView(double maxDistance, int maxEntities) {
        Minecraft client = Minecraft.m_91087_();
        Camera camera = client.f_91063_.m_109153_();
        if (camera == null || client.f_91073_ == null) {
            return Collections.emptyList();
        }
        double maxDistSq = maxDistance * maxDistance;
        double minDistSq = RuOK.get().MinDistance * RuOK.get().MinDistance;
        double fovDeg = CameraUtil.getSafeCullFov();
        double padDeg = 8.0;
        double aabbPad = 0.75;
        Vec3 camPos = camera.m_90583_();
        Vec3 camLook = CameraUtil.getCameraLookVector();
        ArrayList<Entity> important = new ArrayList<Entity>();
        ArrayList<Entity> normal = new ArrayList<Entity>();
        for (Entity e2 : client.f_91073_.m_104735_()) {
            if (e2 == client.f_91074_ || BossTags.isCachedBoss(e2) || EntityCullRender.isWhitelisted(e2) || e2.m_20280_((Entity)client.f_91074_) <= minDistSq) {
                important.add(e2);
                continue;
            }
            normal.add(e2);
        }
        List<Entity> culled = normal.stream().filter(e -> e.m_20280_((Entity)client.f_91074_) <= maxDistSq).filter(e -> !EntityCullRender.isBlacklisted(e)).filter(e -> EntityUtils.isLooselyInView(camPos, camLook, e, fovDeg, 8.0, 0.75)).sorted(Comparator.comparingDouble(e -> e.m_20280_((Entity)client.f_91074_))).limit(Math.max(0, maxEntities - important.size())).toList();
        ArrayList<Entity> out = new ArrayList<Entity>(important);
        out.addAll(culled);
        return List.copyOf(out);
    }

    private static boolean isLooselyInView(Vec3 camPos, Vec3 camLook, Entity e, double fovDeg, double padDeg, double aabbPad) {
        double half = Math.toRadians((fovDeg + padDeg) * 0.5);
        double cosThreshold = Math.cos(half);
        if (EntityUtils.isDirWithinCone(camPos, camLook, e.m_20191_().m_82399_(), cosThreshold)) {
            return true;
        }
        AABB box = e.m_20191_().m_82400_(aabbPad);
        double[] xs = new double[]{box.f_82288_, box.f_82291_};
        double[] ys = new double[]{box.f_82289_, box.f_82292_};
        double[] zs = new double[]{box.f_82290_, box.f_82293_};
        for (double x : xs) {
            for (double y : ys) {
                for (double z : zs) {
                    if (!EntityUtils.isDirWithinCone(camPos, camLook, new Vec3(x, y, z), cosThreshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDirWithinCone(Vec3 camPos, Vec3 camLook, Vec3 target, double cosThreshold) {
        Vec3 v = target.m_82546_(camPos);
        double len = v.m_82553_();
        if (len < 1.0E-6) {
            return true;
        }
        return camLook.m_82526_(v = v.m_82490_(1.0 / len)) >= cosThreshold;
    }

    public static boolean shouldCull(Entity entity) {
        return !EntityUtils.getVisibleEntities().contains(entity);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Component getDebugInfo() {
        return Component.m_237110_((String)"ruok.quality.entity.cull.debug", (Object[])new Object[]{Minecraft.m_91087_().f_91073_.m_104813_(), EntityUtils.getVisibleEntities().size(), Minecraft.m_91087_().f_91073_.m_104813_() - EntityUtils.getVisibleEntities().size()});
    }

    public static final class BossTags {
        public static final TagKey<EntityType<?>> VANILLA = BossTags.of("minecraft:bosses");
        public static final TagKey<EntityType<?>> FORGE = BossTags.of("forge:bosses");
        public static final TagKey<EntityType<?>> COMMON = BossTags.of("c:bosses");
        private static final Set<EntityType<?>> BOSS_CACHE = new HashSet();
        private static boolean initialized = false;

        private static TagKey<EntityType<?>> of(String id) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(id));
        }

        private static void initBossCache() {
            if (initialized) {
                return;
            }
            BuiltInRegistries.f_256780_.forEach(type -> {
                if (type.m_204039_(VANILLA) || type.m_204039_(FORGE) || type.m_204039_(COMMON)) {
                    BOSS_CACHE.add((EntityType<?>)type);
                }
            });
            initialized = true;
        }

        public static boolean isBoss(Entity entity) {
            return entity.m_6095_().m_204039_(VANILLA) || entity.m_6095_().m_204039_(FORGE) || entity.m_6095_().m_204039_(COMMON);
        }

        public static boolean isCachedBoss(Entity entity) {
            return BOSS_CACHE.contains(entity.m_6095_());
        }

        public static Set<EntityType<?>> getBossSet() {
            return BOSS_CACHE;
        }

        static {
            HookDispatcher.register(HookDispatcher.HookType.TICK, BossTags::initBossCache);
        }
    }
}

