/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.particle;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.TaskManager;
import team.teampotato.ruok.util.particle.ParticleRender;

public class ParticleTaskManager {
    private static final Map<Class<? extends Particle>, Queue<Particle>> POOL = new ConcurrentHashMap<Class<? extends Particle>, Queue<Particle>>();
    private static final ThreadLocal<Map<ParticleRenderType, List<Particle>>> THREAD_PARTICLE_MAP = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<List<TrackingEmitter>> THREAD_EMITTER_LIST = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<List<Particle>> THREAD_NEW_PARTICLE_LIST = ThreadLocal.withInitial(ArrayList::new);
    private static final Map<ParticleRenderType, Queue<Particle>> queueCache = new HashMap<ParticleRenderType, Queue<Particle>>();
    private static final AtomicInteger currentTotal = new AtomicInteger(0);
    private static final AtomicInteger droppedNewParticles = new AtomicInteger(0);
    private static final Map<Class<? extends Particle>, AtomicInteger> createdCountMap = new ConcurrentHashMap<Class<? extends Particle>, AtomicInteger>();
    private static final Map<Class<? extends Particle>, AtomicInteger> recycledCountMap = new ConcurrentHashMap<Class<? extends Particle>, AtomicInteger>();

    private static Queue<Particle> getOrCreateQueue(ParticleRenderType sheet) {
        return queueCache.computeIfAbsent(sheet, s -> EvictingQueue.create((int)ParticleTaskManager.getMaxParticlesCount()));
    }

    public static void processParticles(Map<ParticleRenderType, Queue<Particle>> particles, Queue<TrackingEmitter> emitters, @NotNull Queue<Particle> newParticlesQueue, Consumer<ParticleMergeResult> onComplete) {
        Particle p;
        HashMap particlesSnapshot = new HashMap();
        for (Map.Entry<ParticleRenderType, Queue<Particle>> entry : particles.entrySet()) {
            particlesSnapshot.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        ArrayList<TrackingEmitter> emittersSnapshot = new ArrayList<TrackingEmitter>(emitters);
        List<Particle> newParticlesBatch = THREAD_NEW_PARTICLE_LIST.get();
        newParticlesBatch.clear();
        while ((p = newParticlesQueue.poll()) != null) {
            newParticlesBatch.add(p);
        }
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        for (Map.Entry entry : particlesSnapshot.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                ArrayList<Particle> updatedList = new ArrayList<Particle>();
                for (Particle particle : (List)entry.getValue()) {
                    if (!ParticleRender.shouldRawRender(particle)) {
                        ParticleTaskManager.recycleParticle(particle);
                        continue;
                    }
                    try {
                        particle.m_5989_();
                    }
                    catch (Exception e) {
                        ParticleTaskManager.recycleParticle(particle);
                        continue;
                    }
                    if (particle.m_107276_()) {
                        updatedList.add(particle);
                        continue;
                    }
                    ParticleTaskManager.recycleParticle(particle);
                }
                resultMap.put((ParticleRenderType)entry.getKey(), updatedList);
            }, ForkJoinPool.commonPool()));
        }
        CompletableFuture<Void> emitterFuture = CompletableFuture.runAsync(() -> {
            List<TrackingEmitter> updatedEmitters = THREAD_EMITTER_LIST.get();
            updatedEmitters.clear();
            for (TrackingEmitter emitter : emittersSnapshot) {
                try {
                    emitter.m_5989_();
                    if (!emitter.m_107276_()) continue;
                    updatedEmitters.add(emitter);
                }
                catch (Exception exception) {}
            }
        }, ForkJoinPool.commonPool());
        CompletableFuture.allOf((CompletableFuture[])Stream.concat(futures.stream(), Stream.of(emitterFuture)).toArray(CompletableFuture[]::new)).thenRunAsync(() -> {
            HashMap<ParticleRenderType, List<Particle>> finalCopy = new HashMap<ParticleRenderType, List<Particle>>();
            for (Map.Entry entry : resultMap.entrySet()) {
                finalCopy.put((ParticleRenderType)entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            ArrayList<TrackingEmitter> updatedEmitters = new ArrayList<TrackingEmitter>((Collection)THREAD_EMITTER_LIST.get());
            ArrayList<Particle> newParticles = new ArrayList<Particle>(newParticlesBatch);
            onComplete.accept(new ParticleMergeResult(finalCopy, updatedEmitters, newParticles));
        }, TaskManager.getAsyncExecutor());
    }

    public static void applyResults(ParticleMergeResult result, Map<ParticleRenderType, Queue<Particle>> mainParticles, Queue<TrackingEmitter> emitterParticles) {
        Queue queue;
        ParticleRenderType sheet;
        int maxTotalParticles = ParticleTaskManager.getMaxParticlesCount();
        int current = 0;
        int dropped = 0;
        HashMap<ParticleRenderType, Queue> queueMap = new HashMap<ParticleRenderType, Queue>();
        for (ParticleRenderType particleRenderType : result.updated.keySet()) {
            queueMap.put(particleRenderType, mainParticles.computeIfAbsent(particleRenderType, ParticleTaskManager::getOrCreateQueue));
        }
        mainParticles.values().forEach(Collection::clear);
        for (Map.Entry entry : result.updated.entrySet()) {
            List particles;
            sheet = (ParticleRenderType)entry.getKey();
            queue = (Queue)queueMap.get(sheet);
            if (queue == null || (particles = (List)entry.getValue()) == null || particles.isEmpty()) continue;
            int limit = Math.min(particles.size(), maxTotalParticles - current);
            for (int i = 0; i < limit; ++i) {
                Particle p = (Particle)particles.get(i);
                if (p == null) continue;
                queue.add(p);
                ++current;
            }
            if (current < maxTotalParticles) continue;
            break;
        }
        emitterParticles.clear();
        for (TrackingEmitter trackingEmitter : result.emitters) {
            if (trackingEmitter == null) continue;
            emitterParticles.add(trackingEmitter);
        }
        for (Particle particle : result.newParticles) {
            if (particle == null) continue;
            if (current >= maxTotalParticles) {
                ++dropped;
                continue;
            }
            sheet = particle.m_7556_();
            queue = queueMap.computeIfAbsent(sheet, k -> mainParticles.computeIfAbsent((ParticleRenderType)k, ParticleTaskManager::getOrCreateQueue));
            queue.add(particle);
            ++current;
        }
        currentTotal.set(current);
        droppedNewParticles.set(dropped);
    }

    public static <T extends Particle> T obtain(Class<T> cls, Supplier<T> creator) {
        Queue pool = POOL.computeIfAbsent(cls, k -> new ConcurrentLinkedQueue());
        Particle p = (Particle)pool.poll();
        Particle instance = (Particle)cls.cast(p != null ? p : creator.get());
        createdCountMap.computeIfAbsent(cls, k -> new AtomicInteger()).incrementAndGet();
        return (T)instance;
    }

    public static <T extends Particle> void recycleParticle(T particle) {
        if (particle == null) {
            return;
        }
        Queue pool = POOL.computeIfAbsent(particle.getClass(), k -> new ArrayDeque());
        recycledCountMap.computeIfAbsent(particle.getClass(), k -> new AtomicInteger()).incrementAndGet();
        if (pool.size() > 8192) {
            return;
        }
        particle.m_107274_();
        pool.offer(particle);
    }

    public static void onMemoryCleanup() {
        ParticleTaskManager.clearPool();
        queueCache.clear();
        THREAD_PARTICLE_MAP.remove();
        THREAD_EMITTER_LIST.remove();
        THREAD_NEW_PARTICLE_LIST.remove();
    }

    public static void onCleanPoolMemory() {
        ParticleTaskManager.onMemoryCleanup();
        ParticleTaskManager.cleanParticlePool();
    }

    public static void clearPool() {
        POOL.clear();
    }

    public static void cleanParticlePool() {
        int maxSize = 2048;
        for (Map.Entry<Class<? extends Particle>, Queue<Particle>> entry : POOL.entrySet()) {
            Queue<Particle> queue = entry.getValue();
            if (queue.size() <= maxSize) continue;
            int toRemove = queue.size() - maxSize;
            for (int i = 0; i < toRemove; ++i) {
                queue.poll();
            }
        }
    }

    public static int getParticlePoolCount() {
        return POOL.values().stream().mapToInt(Collection::size).sum();
    }

    public static int getMaxParticlesCount() {
        return RuOK.get().ParticleCountLimit;
    }

    public static int getDroppedNewParticles() {
        return droppedNewParticles.get();
    }

    public static int getCurrentParticleCount() {
        return currentTotal.get();
    }

    public static Component buildDebugInfo() {
        int pool = ParticleTaskManager.getParticlePoolCount();
        int cur = ParticleTaskManager.getCurrentParticleCount();
        int drop = ParticleTaskManager.getDroppedNewParticles();
        return Component.m_237110_((String)"ruok.quality.particle.debug", (Object[])new Object[]{pool, cur, drop});
    }

    public record ParticleMergeResult(Map<ParticleRenderType, List<Particle>> updated, List<TrackingEmitter> emitters, List<Particle> newParticles) {
    }
}

