/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import team.teampotato.ruok.config.RuOK;

public class ItemRender {
    public static void render(ItemEntity item, PoseStack matrices, MultiBufferSource vertexConsumers, int light, Quaternionf quaternion) {
        if (!RuOK.get().RenderDisplayItem) {
            return;
        }
        ItemRender.getTotalCountForDisplay(item).ifPresent(text -> {
            if (item.m_32055_().m_41613_() != 0) {
                float itemHeight = item.m_20206_() + 0.5f;
                matrices.m_85836_();
                matrices.m_85837_(0.0, (double)itemHeight, 0.0);
                matrices.m_252781_(quaternion);
                matrices.m_85841_(-0.025f, -0.025f, 0.025f);
                Matrix4f matrix4f = matrices.m_85850_().m_252922_();
                Font textRenderer = Minecraft.m_91087_().f_91062_;
                int textColor = 6;
                int backgroundColor = 0;
                textRenderer.m_272077_((Component)text, (float)(-textRenderer.m_92852_((FormattedText)text)) / 2.0f, 0.0f, textColor, false, matrix4f, vertexConsumers, Font.DisplayMode.NORMAL, backgroundColor, light);
                matrices.m_85849_();
            }
        });
    }

    private static Optional<MutableComponent> getTotalCountForDisplay(@NotNull ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        int count = stack.m_41613_();
        TextColor color = ItemRender.getGradientColor(count);
        MutableComponent displayText = stack.m_41786_().m_6881_().m_130938_(style -> style.m_131148_(color)).m_130946_(" " + count + "x");
        return count > stack.m_41741_() || RuOK.get().isAlwaysShowItemCount ? Optional.of(displayText) : Optional.empty();
    }

    private static TextColor getGradientColor(int count) {
        int min = 1;
        int max = 64;
        int clamped = Math.max(min, Math.min(count, max));
        float t = (float)(clamped - min) / (float)(max - min);
        float h = 120.0f * (1.0f - t);
        float s = 1.0f;
        float l = 0.5f;
        int rgb = ItemRender.hslToRgb(h, s, l);
        return TextColor.m_131266_((int)rgb);
    }

    private static int hslToRgb(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h < 60.0f) {
            r1 = c;
            g1 = x;
        } else if (h < 120.0f) {
            r1 = x;
            g1 = c;
        } else if (h < 180.0f) {
            g1 = c;
            b1 = x;
        } else if (h < 240.0f) {
            g1 = x;
            b1 = c;
        } else if (h < 300.0f) {
            r1 = x;
            b1 = c;
        } else {
            r1 = c;
            b1 = x;
        }
        int r = Math.round((r1 + m) * 255.0f);
        int g = Math.round((g1 + m) * 255.0f);
        int b = Math.round((b1 + m) * 255.0f);
        return r << 16 | g << 8 | b;
    }
}

